/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file;

import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.file.util.FileStoreUtils;
import com.walker.file.FileInfo;
import com.walker.file.FileOperateEngine;
import com.walker.file.FileOperateException;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.core.ApplicationBeanInitialized;
import com.walker.infrastructure.utils.StringUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEngineFactory
implements ApplicationBeanInitialized {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<FileStoreType, FileOperateEngine> fileOperateEngineMap = new HashMap<FileStoreType, FileOperateEngine>(4);
    private boolean remoteAsLocal = true;
    private ArgumentsManager argumentsManager;

    public byte[] downloadOssFile(FileStoreType fileStoreType, String id) {
        try {
            return this.fileOperateEngineMap.get(fileStoreType).downloadFile(id);
        }
        catch (FileOperateException e) {
            throw new PlatformRuntimeException("\u4e0b\u8f7doss\u6587\u4ef6\u9519\u8bef\uff1a" + e.getMessage() + ", id=" + id, (Throwable)e);
        }
    }

    public FileInfo getFileInfo(String id) {
        return this.fileOperateEngineMap.get(FileStoreType.FileSystem).getFileInfo(id);
    }

    public List<FileInfo> getFileInfoList(List<String> ids) {
        return this.fileOperateEngineMap.get(FileStoreType.FileSystem).getFileInfoList(ids);
    }

    @Deprecated
    public FileInfo uploadFileToSystem(InputStream inputStream, String fileName, String groupId, long fileSize) throws FileOperateException {
        return this.uploadFile(FileStoreType.FileSystem, inputStream, fileName, groupId, fileSize);
    }

    public FileInfo uploadFileToLocal(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws FileOperateException {
        return this.uploadFile(FileStoreType.FileSystem, inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo[] uploadFileToLocal(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws FileOperateException {
        return this.uploadFile(FileStoreType.FileSystem, inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    @Deprecated
    public FileInfo uploadFileToFtp(InputStream inputStream, String fileName, String groupId, long fileSize) throws FileOperateException {
        return this.uploadFile(FileStoreType.Ftp, inputStream, fileName, groupId, fileSize);
    }

    public FileInfo uploadFileToFtp(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws FileOperateException {
        if (this.remoteAsLocal) {
            return this.uploadFile(FileStoreType.FileSystem, inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        return this.uploadFile(FileStoreType.Ftp, inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo[] uploadFileToFtp(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws FileOperateException {
        if (this.remoteAsLocal) {
            return this.uploadFile(FileStoreType.FileSystem, inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        return this.uploadFile(FileStoreType.Ftp, inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo uploadFileToOss(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner, FileStoreType fileStoreType) throws FileOperateException {
        if (fileStoreType != FileStoreType.OssQiNiu && fileStoreType != FileStoreType.OssTx && fileStoreType != FileStoreType.OssAli && fileStoreType != FileStoreType.OssAws) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684OSS\u7c7b\u578b\uff1a" + fileStoreType);
        }
        if (this.remoteAsLocal) {
            return this.uploadFile(FileStoreType.FileSystem, inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        return this.uploadFile(fileStoreType, inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo[] uploadFileToOss(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner, FileStoreType fileStoreType) throws FileOperateException {
        if (fileStoreType != FileStoreType.OssQiNiu && fileStoreType != FileStoreType.OssTx && fileStoreType != FileStoreType.OssAli) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684OSS\u7c7b\u578b\uff1a" + fileStoreType);
        }
        if (this.remoteAsLocal) {
            return this.uploadFile(FileStoreType.FileSystem, inputStream, fileName, groupId, fileSize, businessType, owner);
        }
        return this.uploadFile(fileStoreType, inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    @Deprecated
    public FileInfo uploadFile(FileStoreType fileStoreType, InputStream inputStream, String fileName, String groupId, long fileSize) throws FileOperateException {
        FileOperateEngine fileOperateEngine = this.fileOperateEngineMap.get(fileStoreType);
        if (fileOperateEngine == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u5f15\u64ce\uff0cfileStoreType=" + fileStoreType);
        }
        return fileOperateEngine.uploadFile(inputStream, fileName, groupId, fileSize);
    }

    public FileInfo uploadFile(FileStoreType fileStoreType, InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws FileOperateException {
        FileOperateEngine fileOperateEngine = this.fileOperateEngineMap.get(fileStoreType);
        if (fileOperateEngine == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u5f15\u64ce\uff0cfileStoreType=" + fileStoreType);
        }
        return fileOperateEngine.uploadFile(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo[] uploadFile(FileStoreType fileStoreType, InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws FileOperateException {
        FileOperateEngine fileOperateEngine = this.fileOperateEngineMap.get(fileStoreType);
        if (fileOperateEngine == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u5f15\u64ce\uff0cfileStoreType=" + fileStoreType);
        }
        return fileOperateEngine.uploadFile(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public void register(FileStoreType fileStoreType, FileOperateEngine fileOperateEngine) {
        if (fileStoreType == null || fileOperateEngine == null) {
            throw new IllegalArgumentException("\u9519\u8bef\uff1a\u6ce8\u518c '\u6587\u4ef6\u7ba1\u7406\u5f15\u64ce' \u4e3a\u7a7a\u3002");
        }
        this.fileOperateEngineMap.put(fileStoreType, fileOperateEngine);
    }

    public void startup() {
        String fileUrlPrefixConfig = this.getFileUrlPrefix(FileStoreType.FileSystem.getIndex());
        if (StringUtils.isNotEmpty((String)fileUrlPrefixConfig)) {
            FileStoreUtils.fileStoreTypeUrlPrefix.put(FileStoreType.FileSystem.getIndex(), fileUrlPrefixConfig);
        }
        if (StringUtils.isNotEmpty((String)(fileUrlPrefixConfig = this.getFileUrlPrefix(FileStoreType.Ftp.getIndex())))) {
            FileStoreUtils.fileStoreTypeUrlPrefix.put(FileStoreType.Ftp.getIndex(), fileUrlPrefixConfig);
        }
        if (StringUtils.isNotEmpty((String)(fileUrlPrefixConfig = this.getFileUrlPrefix(FileStoreType.OssQiNiu.getIndex())))) {
            FileStoreUtils.fileStoreTypeUrlPrefix.put(FileStoreType.OssQiNiu.getIndex(), fileUrlPrefixConfig);
        }
        if (StringUtils.isNotEmpty((String)(fileUrlPrefixConfig = this.getFileUrlPrefix(FileStoreType.OssTx.getIndex())))) {
            FileStoreUtils.fileStoreTypeUrlPrefix.put(FileStoreType.OssTx.getIndex(), fileUrlPrefixConfig);
        }
        if (StringUtils.isNotEmpty((String)(fileUrlPrefixConfig = this.getFileUrlPrefix(FileStoreType.OssAli.getIndex())))) {
            FileStoreUtils.fileStoreTypeUrlPrefix.put(FileStoreType.OssAli.getIndex(), fileUrlPrefixConfig);
        }
        if (StringUtils.isNotEmpty((String)(fileUrlPrefixConfig = this.getFileUrlPrefix(FileStoreType.OssAws.getIndex())))) {
            FileStoreUtils.fileStoreTypeUrlPrefix.put(FileStoreType.OssAws.getIndex(), fileUrlPrefixConfig);
        }
    }

    private String getFileUrlPrefix(String fileStoreType) {
        this.logger.info("setup fileStoreType = {}", (Object)fileStoreType);
        String fileUrlKey = FileStoreUtils.getFileUrlPrefixKey(fileStoreType);
        if (StringUtils.isEmpty((String)fileUrlKey)) {
            this.logger.error("fileUrlKey\u4e3a\u7a7a\uff0c\u8be5\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b\u65e0\u6cd5\u83b7\u53d6\u914d\u7f6e\uff0cfileStoreType = " + fileStoreType);
            return null;
        }
        Variable var = this.argumentsManager.getVariable(fileUrlKey);
        if (var == null) {
            this.logger.error("argumentsManager\u83b7\u53d6\u53c2\u6570\u4e3a\u7a7a! fileUrlKey=" + fileUrlKey);
            return null;
        }
        return var.getStringValue();
    }

    public void setArgumentsManager(ArgumentsManager argumentsManager) {
        this.argumentsManager = argumentsManager;
    }

    public void setRemoteAsLocal(boolean remoteAsLocal) {
        this.remoteAsLocal = remoteAsLocal;
    }
}

