/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.controller;

import com.iplatform.base.SystemController;
import com.iplatform.file.service.FileServiceImpl;
import com.iplatform.file.util.FileResultUtils;
import com.iplatform.file.util.FileStoreUtils;
import com.iplatform.file.util.ImageUtils;
import com.iplatform.model.po.SfAttachment;
import com.walker.db.page.GenericPager;
import com.walker.file.FileInfo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/platform/attachment"})
public class AttachmentController
extends SystemController {
    private FileServiceImpl fileService = null;

    @Autowired
    public AttachmentController(FileServiceImpl fileService) {
        this.fileService = fileService;
    }

    @RequestMapping(value={"/upload/file"}, method={RequestMethod.POST})
    public ResponseValue uploadFile(MultipartFile multipart, String model, Integer pid) {
        String owner = String.valueOf(this.getOwner());
        String fileStoreType = this.getArgumentVariable("uploadType").getStringValue();
        try {
            FileInfo fileInfo = null;
            fileInfo = fileStoreType.equals("fs") ? this.uploadFileToLocal(multipart, null, pid, owner, "uploadf") : this.uploadFileToRemote(multipart, null, pid, owner, "uploadf");
            return ResponseValue.success((Object)FileResultUtils.acquireFileResultVo(fileInfo, multipart.getContentType()));
        }
        catch (Exception ex) {
            this.logger.error("\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef\uff1a" + ex.getMessage(), (Throwable)ex);
            return ResponseValue.error((String)ex.getMessage());
        }
    }

    @RequestMapping(value={"/upload/image"}, method={RequestMethod.POST})
    public ResponseValue uploadImage(MultipartFile multipart, String model, Integer pid) {
        String owner = String.valueOf(this.getOwner());
        String fileStoreType = this.getArgumentVariable("uploadType").getStringValue();
        try {
            FileInfo fileInfo = null;
            fileInfo = fileStoreType.equals("fs") ? this.uploadFileToLocal(multipart, null, pid, owner, "uploadi") : this.uploadFileToRemote(multipart, null, pid, owner, "uploadi");
            return ResponseValue.success((Object)FileResultUtils.acquireFileResultVo(fileInfo, multipart.getContentType()));
        }
        catch (Exception ex) {
            this.logger.error("\u56fe\u7247\u4e0a\u4f20\u9519\u8bef\uff1a" + ex.getMessage(), (Throwable)ex);
            return ResponseValue.error((String)ex.getMessage());
        }
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(Integer pid, String attType) {
        List<String> attTypeList = null;
        if (StringUtils.isNotEmpty((String)attType)) {
            attTypeList = ImageUtils.acquireFileTypeList(attType);
        }
        long owner = this.getOwner();
        this.logger.debug("owner = " + owner);
        GenericPager<SfAttachment> pager = this.fileService.queryPageAttachmentList((int)owner, pid, attTypeList);
        if (pager.getDatas() != null) {
            String fileStoreType = null;
            for (SfAttachment attachment : pager.getDatas()) {
                fileStoreType = attachment.getFileStoreType();
                if (StringUtils.isEmpty((String)attachment.getSattDir())) continue;
                attachment.setSattDir(FileStoreUtils.fileStoreTypeUrlPrefix.get(fileStoreType) + attachment.getSattDir());
            }
        }
        return ResponseValue.success(pager);
    }
}

