/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.controller;

import com.iplatform.base.SystemController;
import com.walker.file.FileInfo;
import com.walker.infrastructure.utils.FileCopyUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oss"})
public class OssFileApi
extends SystemController {
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public void downloadOssFile(@PathVariable(name="id") String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6");
        }
        FileInfo fileInfo = this.acquireFileOperateSpi().getFileInfo(Long.parseLong(id));
        if (fileInfo == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0cid=" + id);
        }
        try {
            byte[] fileContent = this.getOssFileData(id);
            this.downloadSimpleFile(fileContent, fileInfo.getFileName());
        }
        catch (IOException e) {
            this.logger.error("\u4e0b\u8f7doss\u9519\u8bef:" + e.getMessage() + ", id=" + id, (Throwable)e);
            ServletUtils.renderString((HttpServletResponse)this.getResponse(), (String)("\u4e0b\u8f7doss\u9519\u8bef:" + e.getMessage() + ", id=" + id));
        }
    }

    @RequestMapping(value={"/test/demo"}, method={RequestMethod.GET})
    public void downloadOssDemo() {
        String file = "F:/app_ocr_demo/ocr_e_005.jpg";
        try {
            this.downloadSimpleFile(FileCopyUtils.copyToByteArray((File)new File(file)), "\u6d4b\u8bd5\u56fe\u7247");
        }
        catch (IOException e) {
            this.logger.error("\u4e0b\u8f7doss demo\u9519\u8bef:" + e.getMessage() + ", id=" + file, (Throwable)e);
            ServletUtils.renderString((HttpServletResponse)this.getResponse(), (String)("\u4e0b\u8f7doss demo\u9519\u8bef:" + e.getMessage() + ", id=" + file));
        }
    }
}

