/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.service;

import com.iplatform.model.po.S_file;
import com.iplatform.model.po.SfAttachment;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
extends BaseServiceImpl {
    public static final String SQL_PAGE_FILE = "select * from s_file where 1=1";
    public static final String SQL_PAGE_ATTACHMENT = "select * from sf_attachment where 1=1";

    public GenericPager<SfAttachment> queryPageAttachmentList(int owner, Integer pid, List<String> attTypeList) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_ATTACHMENT);
        sql.append(" and owner = :owner");
        parameters.put("owner", owner);
        if (pid != null && pid > 0) {
            sql.append(" and pid = :pid");
            parameters.put("pid", pid);
        }
        if (!StringUtils.isEmptyList(attTypeList)) {
            sql.append(" and att_type in (:attTypeList)");
            parameters.put("attTypeList", attTypeList);
        }
        sql.append(" order by create_time desc");
        return this.selectSplit(sql.toString(), parameters, new SfAttachment());
    }

    @Deprecated
    public GenericPager<S_file> queryPageFileList(String fileName, String fileExt, String groupId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_FILE);
        if (StringUtils.isNotEmpty((String)fileName)) {
            sql.append(" and file_name like :fileName");
            parameters.put("fileName", "%" + fileName + "%");
        }
        if (StringUtils.isNotEmpty((String)fileExt)) {
            sql.append(" and file_ext = :fileExt");
            parameters.put("fileExt", fileExt);
        }
        if (StringUtils.isNotEmpty((String)groupId)) {
            sql.append(" and group_id = :groupId");
            parameters.put("groupId", groupId);
        }
        sql.append(" order by create_time desc");
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_file());
    }
}

