/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.support;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.S3Actions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.services.s3.model.CORSRule;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketPolicyRequest;
import com.iplatform.file.support.AbstractOssFileEngine;
import com.walker.file.DefaultFileInfo;
import com.walker.file.FileInfo;
import com.walker.file.FileOperateException;
import com.walker.file.FileStoreType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class AwsOssFileEngine
extends AbstractOssFileEngine {
    private String bucketName = "ctoms-file";
    public String endpoint = "http://10.10.5.1:8080";
    private String accessKey = "4XJOR8RXEWWRVV8N4HOC";
    private String secretKey = "123456asdfghj";
    private AmazonS3 amazonS3Client;

    protected void executeUpload(InputStream inputStream, FileInfo fileInfo) throws FileOperateException {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("plain/text");
        metadata.addUserMetadata("x-amz-meta-title", fileInfo.getFileName());
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, fileInfo.getId(), inputStream, metadata);
            PutObjectResult result = this.amazonS3Client.putObject(putObjectRequest);
            StringBuilder url = new StringBuilder(this.getPrefix());
            url.append(fileInfo.getId());
            ((DefaultFileInfo)fileInfo).setFileSize(result.getMetadata().getContentLength());
            ((DefaultFileInfo)fileInfo).setUrl(url.toString());
        }
        catch (Exception var11) {
            throw new FileOperateException("\u4fdd\u5b58\u6587\u4ef6\u5230\u3010oss\u3011\u9519\u8bef:" + var11.getMessage() + ", id=" + fileInfo.getId(), (Throwable)var11);
        }
    }

    protected byte[] executeDownload(FileInfo fileInfo) throws FileOperateException {
        S3Object object = this.amazonS3Client.getObject(this.bucketName, fileInfo.getId());
        S3ObjectInputStream objectContent = object.getObjectContent();
        ByteArrayOutputStream fileOutputStream = new ByteArrayOutputStream();
        try {
            byte[] readBuf = new byte[20480];
            int read_len = 0;
            while ((read_len = objectContent.read(readBuf)) > 0) {
                fileOutputStream.write(readBuf, 0, read_len);
            }
            byte[] byArray = fileOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            throw new FileOperateException("\u4e0b\u8f7d\u6587\u4ef6\u9519\u8bef\uff1a" + ex.getMessage() + ", fileId=" + fileInfo.getId(), (Throwable)ex);
        }
        finally {
            try {
                objectContent.close();
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public FileStoreType getFileStoreType() {
        return FileStoreType.OssAws;
    }

    public void close() {
        super.close();
        this.closeAmazonS3Client();
    }

    public void initS3Client() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        ClientConfiguration connconfig = new ClientConfiguration();
        connconfig.setProtocol(Protocol.HTTP);
        this.amazonS3Client = new AmazonS3Client((AWSCredentials)credentials, connconfig);
        this.amazonS3Client.setEndpoint(this.endpoint);
        this.amazonS3Client.setS3ClientOptions(S3ClientOptions.builder().setPathStyleAccess(true).disableChunkedEncoding().build());
    }

    public void setBucketPolicy() throws IOException {
        Policy bucket_policy = new Policy().withStatements(new Statement[]{new Statement(Statement.Effect.Allow).withPrincipals(new Principal[]{Principal.AllUsers}).withActions(new Action[]{S3Actions.GetObject}).withResources(new Resource[]{new Resource("arn:aws:s3:::" + this.bucketName + "/*")})});
        SetBucketPolicyRequest setBucketPolicyRequest = new SetBucketPolicyRequest(this.bucketName, bucket_policy.toJson());
        this.amazonS3Client.setBucketPolicy(setBucketPolicyRequest);
    }

    public void configBucketCors() {
        BucketCrossOriginConfiguration conf = new BucketCrossOriginConfiguration().withRules(new CORSRule[]{new CORSRule().withId("1").withAllowedHeaders(Arrays.asList("*")).withAllowedMethods(Arrays.asList(CORSRule.AllowedMethods.GET, CORSRule.AllowedMethods.PUT))});
        SetBucketCrossOriginConfigurationRequest req = new SetBucketCrossOriginConfigurationRequest("bkt", conf);
        this.amazonS3Client.setBucketCrossOriginConfiguration(req);
    }

    private void closeAmazonS3Client() {
        if (this.amazonS3Client != null) {
            this.amazonS3Client.shutdown();
        }
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }
}

