package com.iplatform.gateway.config;

import com.iplatform.gateway.filter.RouteRecordGlobalFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration
public class FilterConfig {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    public RouteRecordGlobalFilter routeRecordGlobalFilter(){
        logger.info("创建 全局过滤器:RouteRecordGlobalFilter");
        return new RouteRecordGlobalFilter();
    }

    /**
     * 允许 Gateway 跨域请求。
     * <pre>
     *     1) 2022-12-28 由于在管理模块中已经配置了跨域，因此在Gateway也配置就重复了，
     *     这里后面要采用动态过滤，针对每个业务系统配置是否需要跨域。
     *     2)
     * </pre>
     * @return
     * @date 2022-12-28
     */
    @Bean
    public CorsWebFilter corsFilter(){
        CorsConfiguration config = new CorsConfiguration();
//        config.addAllowedMethod("GET,POST");
        config.addAllowedMethod("*");
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");

        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource(new PathPatternParser());
        source.registerCorsConfiguration("/**", config);

        return new CorsWebFilter(source);
    }
}
