/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.gateway.filter;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RouteRecordGlobalFilter
implements GlobalFilter,
Ordered {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI proxyRequestUri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        long start = System.currentTimeMillis();
        return chain.filter(exchange).then(Mono.fromRunnable(() -> {
            long end = System.currentTimeMillis();
            this.logger.info("\u5b9e\u9645\u8c03\u7528\u5730\u5740\u4e3a\uff1a{}\uff0c\u8c03\u7528\u8017\u65f6\u4e3a\uff1a{}ms", (Object)proxyRequestUri, (Object)(end - start));
        }));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

