package com.iplatform.generator;

import com.iplatform.base.LocalDatabaseMetaEngine;
import com.walker.db.TableInfo;
import com.walker.db.page.GenericPager;
import com.walker.dbmeta.FieldInfo;
import com.walker.infrastructure.utils.StringUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.FileOutputStream;
import java.util.List;

//@Component
public class JdbcGeneratorEngine {

//    @Autowired
    private JdbcGeneratorServiceImpl jdbcGeneratorService = null;

    private LocalDatabaseMetaEngine localDatabaseMetaEngine = null;

    @Autowired
    public JdbcGeneratorEngine(JdbcGeneratorServiceImpl jdbcGeneratorService, LocalDatabaseMetaEngine localDatabaseMetaEngine){
        this.jdbcGeneratorService = jdbcGeneratorService;
        this.localDatabaseMetaEngine = localDatabaseMetaEngine;
    }

    /**
     * 返回字段信息集合
     * @param tableName 表名称
     * @return
     * @date 2022-11-22
     */
    public List<FieldInfo> getFieldsObject(String tableName){
        return this.localDatabaseMetaEngine.getFieldsObject(tableName);
    }

    /**
     * 返回表名称集合。
     * @param tableNameLike 模糊查询表前缀
     * @return
     * @date 2022-11-22
     */
    public List<String> getTableNamesByLike(String tableNameLike){
        return this.localDatabaseMetaEngine.getTableNamesByLike(tableNameLike);
    }

    /**
     * 分页返回表信息集合。当前页信息通过对象: ListPageContext.getCurrentPageIndex()方法获得。
     * @param tableNameLike 表名模糊查询，如果为空字符串则查询所有。
     * @return
     * @date 2022-11-22
     */
    public GenericPager<TableInfo> queryPageTableNamesByLike(String tableNameLike
//			, int pageIndex, int pageSize
    ){
        return this.localDatabaseMetaEngine.queryPageTableNamesByLike(tableNameLike);
    }

    /**
     * 返回指定表元数据对象。
     * @param tableName 表名称
     * @return
     * @date 2022-11-26
     */
    public TableInfo queryOneTableInfo(String tableName){
        return this.localDatabaseMetaEngine.queryOneTableInfo(tableName);
    }

    /**
     * 生成相应前缀的表PO对象。
     * @param tableNamePrefix 前缀名，儒：sys_
     * @param mbbs 生成标识，默认为：po,mapper
     * @param outputFile 生成的文件，如：d:/po.zip
     * @throws Exception 如果失败抛出异常
     */
    public void generatePoFile(String tableNamePrefix, String mbbs, String outputFile) throws Exception{
        if(StringUtils.isEmpty(mbbs)){
//            mbbs = "po,mapper";
            mbbs = TEMPLATE_PO_MBBS;
        }
        byte[] fileContent = this.jdbcGeneratorService.generatorPoCode(tableNamePrefix, mbbs);
        IOUtils.write(fileContent, new FileOutputStream(outputFile));
//        Files.newOutputStream(Paths.get(URI.create(outputFile)));
    }

    /**
     * 获得一个表的PO生成文件，返回一个zip压缩包。<p></p>
     * 该方法在代码生成功能中，让用户下载一个表数据库PO文件。
     * @param tableName 表名称
     * @return
     * @date 2022-11-28
     */
    public byte[] generateOnePoZipFile(String tableName){
        return this.jdbcGeneratorService.generatorPoCode(tableName, TEMPLATE_PO_MBBS, true);
    }

    /**
     * 生成一个表的po文件。
     * @param tableName 具体的表名称，不是前缀
     * @param outputFile
     * @throws Exception
     */
    public void generateOnePoFile(String tableName, String outputFile) throws Exception{
        byte[] fileContent = this.jdbcGeneratorService.generatorPoCode(tableName, TEMPLATE_PO_MBBS, true);
        IOUtils.write(fileContent, new FileOutputStream(outputFile));
    }

    public static final String TEMPLATE_PO_MBBS = "po,mapper";

    /*@PostConstruct
    public void init(){
        System.out.println("~~~~~~~~~~~~~~~ 开始生成数据库代码：");
        try {
            this.generatePoFile("auto_", "po,mapper", "f:/项目/springboot/po.zip");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }*/
}
