package com.iplatform.generator.config;

import com.iplatform.base.LocalDatabaseMetaEngine;
import com.iplatform.generator.JdbcGeneratorEngine;
import com.iplatform.generator.JdbcGeneratorServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JdbcGeneratorConfig {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    private JdbcGeneratorServiceImpl jdbcGeneratorService;
//    private JdbcInspector jdbcInspector;
//    private LocalDatabaseMetaEngine localDatabaseMetaEngine;

    @Autowired
    public JdbcGeneratorConfig(JdbcGeneratorServiceImpl jdbcGeneratorService
//            , JdbcInspector jdbcInspector
//            , LocalDatabaseMetaEngine localDatabaseMetaEngine
    ){
        this.jdbcGeneratorService = jdbcGeneratorService;
//        this.jdbcInspector = jdbcInspector;
//        this.localDatabaseMetaEngine = localDatabaseMetaEngine;
    }

//    /**
//     * 创建本地数据库元数据引擎(单例)对象。
//     * @return
//     * @date 2022-11-22
//     */
//    @Bean
//    public LocalDatabaseMetaEngine localDatabaseMetaEngine(){
//        LocalAddress localAddress = new LocalAddress(jdbcInspector.getPrimaryDataSourceMeta());
//
//        LocalDatabaseMetaEngine localDatabaseMetaEngine = new LocalDatabaseMetaEngine();
//        localDatabaseMetaEngine.setDatabaseType(jdbcInspector.getPrimaryDatabaseType());
//        localDatabaseMetaEngine.setLocalAddress(localAddress);
//        logger.info("创建: localDatabaseMetaEngine = " + localDatabaseMetaEngine);
//        return localDatabaseMetaEngine;
//    }

    /**
     * 创建代码生成器引擎(单例)对象。
     * @return
     * @date 2022-11-22
     */
    @Bean
    public JdbcGeneratorEngine jdbcGeneratorEngine(LocalDatabaseMetaEngine localDatabaseMetaEngine){
        return new JdbcGeneratorEngine(this.jdbcGeneratorService, localDatabaseMetaEngine);
    }

    /**
     * 代码生成属性配置，暂时使用其中部分属性，配置文件直接参考若依。
     * @return
     * @date 2022-11-26
     */
    @Bean
    public JdbcGeneratorProperties jdbcGeneratorProperties(){
        JdbcGeneratorProperties jdbcGeneratorProperties = new JdbcGeneratorProperties();
        logger.info("jdbcGeneratorProperties, " + jdbcGeneratorProperties.getPackageName());
        return jdbcGeneratorProperties;
    }
}
