package com.iplatform.generator.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "iplatform.gen")
//@PropertySource(value = { "classpath:generator.yml" })
public class JdbcGeneratorProperties {

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getTablePrefix() {
        return tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    /** 作者 */
    public String author;

    /** 生成包路径 */
    public String packageName;

    public Boolean getAutoRemovePre() {
        return autoRemovePre;
    }

    public void setAutoRemovePre(Boolean autoRemovePre) {
        this.autoRemovePre = autoRemovePre;
    }

    /** 自动去除表前缀，默认是false */
    public Boolean autoRemovePre;

    /** 表前缀(类名不会包含表前缀) */
    public String tablePrefix;
}
