package com.iplatform.generator.service;

import com.iplatform.model.po.S_gen_column;
import com.iplatform.model.po.S_gen_table;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CodeGenServiceImpl extends BaseServiceImpl {

    private static final String SQL_PAGE_GEN_TABLE = "select * from s_gen_table where 1=1";
    private static final String SQL_QUERY_GEN_COLUMNS = "select * from s_gen_column where table_id=? order by sort";

    /**
     * 查询给定表对应的列集合。
     * @param tableId s_gen_table id
     * @return
     */
    public List<S_gen_column> queryGenColumnList(long tableId){
        return this.select(SQL_QUERY_GEN_COLUMNS, new Object[]{tableId}, new S_gen_column());
    }

    /**
     * 分页查询已生成的表记录。
     * @param tableName 模糊查询的表名称
     * @param tableComment 模糊查询的备注
     * @return
     * @date 2022-11-25
     */
    public GenericPager<S_gen_table> queryPageGenTable(String tableName, String tableComment) {
        Map<String, Object> parameters = new HashMap<>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_GEN_TABLE);

        if(StringUtils.isNotEmpty(tableName)){
            sql.append(" and table_name like :tableName");
            parameters.put("tableName", "%" + tableName + "%");
        }
        if(StringUtils.isNotEmpty(tableComment)){
            sql.append(" and table_comment like :tableComment");
            parameters.put("tableComment", "%" + tableComment + "%");
        }

        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), new S_gen_table());
    }

    public void execInsertOneTableAndColumnList(S_gen_table s_gen_table, List<S_gen_column> columnList){
        this.insert(s_gen_table);
        if(columnList != null){
            this.insert(columnList);
        }
    }

    public void execDeleteTableAndColumnList(long tableId){
        this.delete(new S_gen_table(tableId));
        this.delete(new S_gen_column(), "where table_id=?", new Object[]{tableId});
    }
}
