package com.iplatform.generator.util;

import com.iplatform.generator.GenConstants;
import com.iplatform.model.po.S_gen_column;
import com.iplatform.model.po.S_gen_table;
import com.walker.db.TableInfo;
import com.walker.dbmeta.FieldInfo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.generator.util.GenUtils;

import java.util.Arrays;

/**
 * 代码生成工具类，目前参考了若依的vue前端生成，后台数据库则使用自己原有框架，<p></p>
 * 但目前按照管理界面，仅能一次选择一个表生成。
 * @date 2022-11-26
 */
public class CodeGenUtils {

    public static final S_gen_column createGenColumn(FieldInfo fieldInfo, String userName, long tableId){
        boolean isPk = false;
        String dataType = getDbType(fieldInfo.getDataType());
        S_gen_column s_gen_column = new S_gen_column();
        s_gen_column.setColumn_id(NumberGenerator.getLongSequenceNumber());
        s_gen_column.setCreate_time(DateUtils.getDateTimeNumber(System.currentTimeMillis()));
        s_gen_column.setCreate_by(userName);
        s_gen_column.setColumn_name(fieldInfo.getFieldName());
        s_gen_column.setTable_id(String.valueOf(tableId));
        s_gen_column.setColumn_comment(fieldInfo.getSummary());
        s_gen_column.setColumn_type(fieldInfo.getDataType());
        s_gen_column.setSort(fieldInfo.getColumnId());
        if(StringUtils.isNotEmpty(fieldInfo.getColumnKey()) && fieldInfo.getColumnKey().equalsIgnoreCase("PRI")){
            s_gen_column.setIs_pk("1");
            isPk = true;
        } else {
            s_gen_column.setIs_pk("0");
        }

        //
        s_gen_column.setJava_field(fieldInfo.getFieldName());
        s_gen_column.setQuery_type(GenConstants.QUERY_EQ);

        if (arraysContains(GenConstants.COLUMNTYPE_STR, dataType)
                || arraysContains(GenConstants.COLUMNTYPE_TEXT, dataType)) {
            // 字符串长度超过500设置为文本域
//            Integer columnLength = getColumnLength(column.getColumnType());
//            String htmlType = columnLength >= 500 || arraysContains(GenConstants.COLUMNTYPE_TEXT, dataType) ? GenConstants.HTML_TEXTAREA : GenConstants.HTML_INPUT;
            String htmlType = arraysContains(GenConstants.COLUMNTYPE_TEXT, dataType) ? GenConstants.HTML_TEXTAREA : GenConstants.HTML_INPUT;
            s_gen_column.setHtml_type(htmlType);

        } else if (arraysContains(GenConstants.COLUMNTYPE_TIME, dataType)) {
            s_gen_column.setJava_field(GenConstants.TYPE_DATE);
            s_gen_column.setHtml_type(GenConstants.HTML_DATETIME);

        } else if (arraysContains(GenConstants.COLUMNTYPE_NUMBER, dataType)){
            s_gen_column.setHtml_type(GenConstants.HTML_INPUT);

            // 如果是浮点型 统一用double
            if(fieldInfo.getScale() > 0){
                s_gen_column.setJava_type(GenConstants.TYPE_DOUBLE);
            } else if (fieldInfo.getPrecision() > 0 && fieldInfo.getPrecision() <= 10) {
                // 如果是整形
                s_gen_column.setJava_type(GenConstants.TYPE_INTEGER);
            } else {
                // 长整型
                s_gen_column.setJava_type(GenConstants.TYPE_LONG);
            }
        }

        // 插入字段（默认所有字段都需要插入）
        s_gen_column.setIs_insert(GenConstants.REQUIRE);
        // 编辑字段
        if (!arraysContains(GenConstants.COLUMNNAME_NOT_EDIT, fieldInfo.getFieldName()) && !isPk) {
            s_gen_column.setIs_edit(GenConstants.REQUIRE);
        }
        // 列表字段
        if (!arraysContains(GenConstants.COLUMNNAME_NOT_LIST, fieldInfo.getFieldName()) && !isPk) {
            s_gen_column.setIs_list(GenConstants.REQUIRE);
        }
        // 查询字段
        if (!arraysContains(GenConstants.COLUMNNAME_NOT_QUERY, fieldInfo.getFieldName()) && !isPk) {
            s_gen_column.setIs_query(GenConstants.REQUIRE);
        }
        // 查询字段类型
        if (fieldInfo.getFieldName().endsWith("name") || fieldInfo.getFieldName().endsWith("title")) {
            s_gen_column.setQuery_type(GenConstants.QUERY_LIKE);
        }
        // 状态字段设置单选框
        if (fieldInfo.getFieldName().endsWith("status")) {
            s_gen_column.setHtml_type(GenConstants.HTML_RADIO);
        }
        // 类型&性别字段设置下拉框
        else if (fieldInfo.getFieldName().endsWith("type")
                || fieldInfo.getFieldName().endsWith("sex")) {
            s_gen_column.setHtml_type(GenConstants.HTML_SELECT);
        }
        // 图片字段设置图片上传控件
        else if (fieldInfo.getFieldName().endsWith("image")) {
            s_gen_column.setHtml_type(GenConstants.HTML_IMAGE_UPLOAD);
        }
        // 文件字段设置文件上传控件
        else if (fieldInfo.getFieldName().endsWith("file")) {
            s_gen_column.setHtml_type(GenConstants.HTML_FILE_UPLOAD);
        }
        // 内容字段设置富文本控件
        else if (fieldInfo.getFieldName().endsWith("content")) {
            s_gen_column.setHtml_type(GenConstants.HTML_EDITOR);
        }
        return s_gen_column;
    }

    public static final S_gen_table createGenTable(TableInfo tableInfo, String userName, String packageName){
        S_gen_table s_gen_table = new S_gen_table();
        s_gen_table.setTable_id(NumberGenerator.getSequenceNumber());
        s_gen_table.setCreate_time(DateUtils.getDateTimeNumber(System.currentTimeMillis()));
        s_gen_table.setCreate_by(userName);
        s_gen_table.setTable_name(tableInfo.getName());
        s_gen_table.setTable_comment(tableInfo.getSummary());
//        s_gen_table.setClass_name(convertClassName(genTable.getTableName()));
        s_gen_table.setClass_name(GenUtils.toUpperFirst(tableInfo.getName()));
        s_gen_table.setPackage_name(packageName);
        s_gen_table.setModule_name(getModuleName(packageName));
        s_gen_table.setBusiness_name(getBusinessName(tableInfo.getName()));
        s_gen_table.setFunction_name(tableInfo.getSummary());
        s_gen_table.setFunction_author(userName);
        return s_gen_table;
    }

    /**
     * 获取业务名
     *
     * @param tableName 表名
     * @return 业务名
     */
    public static String getBusinessName(String tableName) {
        int lastIndex = tableName.lastIndexOf("_");
        int nameLength = tableName.length();
        return substring(tableName, lastIndex + 1, nameLength);
    }

    /**
     * 获取模块名
     *
     * @param packageName 包名
     * @return 模块名
     */
    public static String getModuleName(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        int nameLength = packageName.length();
        return substring(packageName, lastIndex + 1, nameLength);
    }

    /**
     * 获取数据库类型字段
     *
     * @param columnType 列类型
     * @return 截取后的列类型
     */
    public static String getDbType(String columnType) {
        if (columnType.indexOf("(") > 0) {
            return substringBefore(columnType, "(");
        } else {
            return columnType;
        }
    }

    /**
     * 校验数组是否包含指定值
     *
     * @param arr 数组
     * @param targetValue 值
     * @return 是否包含
     */
    public static boolean arraysContains(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    public static String substringBefore(final String str, final String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return StringUtils.EMPTY_STRING;
        }
        final int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    /**
     * 截取字符串
     *
     * @param str 字符串
     * @param start 开始
     * @param end 结束
     * @return 结果
     */
    public static String substring(final String str, int start, int end) {
        if (str == null) {
            return StringUtils.EMPTY_STRING;
        }

        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }

        if (end > str.length()) {
            end = str.length();
        }

        if (start > end) {
            return StringUtils.EMPTY_STRING;
        }

        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }
}
