package com.iplatform.generator.util;

import com.walker.db.DatabaseType;

public class DataTypeUtils {

    public static final String PRIMARY_KEY_MYSQL = "PRI";
    public static final String PRIMARY_KEY_ORACLE = "P";

    public static boolean isMysql(DatabaseType databaseType){
//        if (databaseType == DatabaseType.ORACLE || databaseType == DatabaseType.DAMENG) {
//            return false;
//        } else {
//            return true;
//        }
        return databaseType == DatabaseType.MYSQL || databaseType == DatabaseType.SQLITE;
    }

    public static boolean isOracle(DatabaseType databaseType){
        if (databaseType == DatabaseType.ORACLE || databaseType == DatabaseType.DAMENG) {
            return true;
        }
        return false;
    }

    public static boolean isPrimaryColumn(String columnKey){
        if(columnKey.equalsIgnoreCase(PRIMARY_KEY_MYSQL) || columnKey.equalsIgnoreCase(PRIMARY_KEY_ORACLE)){
            return true;
        }
        return false;
    }

    public static String getType(String type_name, int column_size, int decimal_digits) {
        if (type_name.contains("CHAR")
                || type_name.toLowerCase().indexOf("varchar") >= 0
                || type_name.equalsIgnoreCase("nvarchar2")
                // PG数据库字符串字段类型，2023-10-10
                || type_name.indexOf("character") >= 0)
            return "string";
        if (("NUMBER".equalsIgnoreCase(type_name)) || ("DECIMAL".equalsIgnoreCase(type_name))) {
            if (decimal_digits == 0) {
                if (column_size > 0 && column_size <= 8) {
                    return "int";
                }
                return "long";
            }

            if (column_size < 14) {
                return "double";
            }
            return "big_decimal";
        }

        // 2023-10-10 postgresql
        if(type_name.equalsIgnoreCase("integer")){
            if(column_size > 4){
                // 8 位表示长整形
                return "long";
            } else {
                return "int";
            }
        }
        if(type_name.indexOf("numeric") >= 0){
            return "double";
        }

        if (("DATE".equalsIgnoreCase(type_name)) || ("DATETIME".equalsIgnoreCase(type_name)) || (type_name.startsWith("TIMESTAMP")))
            return "date";
        if ("INT".equalsIgnoreCase(type_name))
            return "int";
        if (("Long".equalsIgnoreCase(type_name)) || ("BIGINT".equalsIgnoreCase(type_name)))
            return "long";
        if ("FLOAT".equalsIgnoreCase(type_name))
            return "float";
        if ("SMALLINT".equalsIgnoreCase(type_name))
            return "int";
        if ("TINYINT".equalsIgnoreCase(type_name))
            return "byte";
        if ("DOUBLE".equalsIgnoreCase(type_name) || type_name.indexOf("double") >= 0)
            return "double";
        if (("CLOB".equalsIgnoreCase(type_name)) || ("TEXT".equalsIgnoreCase(type_name)) || ("MEDIUMTEXT".equalsIgnoreCase(type_name)) || ("LONGTEXT".equalsIgnoreCase(type_name)))
//            return "materialized_clob";
            return "string";
        if (type_name.contains("BLOB")) {
            return "materialized_blob";
        }
        throw new RuntimeException("类型 " + type_name + " 不支持! ");
    }

}
