package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_GEN_COLUMN *
 * @author genrator
 */
public class S_gen_column_mapper extends S_gen_column implements BaseMapper<S_gen_column> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_gen_column> ROW_MAPPER = new S_gen_columnRowMapper();

    // 主键
    public static final String COLUMN_ID = "column_id";
    // 普通属性
    public static final String TABLE_ID = "table_id";
    public static final String COLUMN_NAME = "column_name";
    public static final String COLUMN_COMMENT = "column_comment";
    public static final String COLUMN_TYPE = "column_type";
    public static final String JAVA_TYPE = "java_type";
    public static final String JAVA_FIELD = "java_field";
    public static final String IS_PK = "is_pk";
    public static final String IS_INCREMENT = "is_increment";
    public static final String IS_REQUIRED = "is_required";
    public static final String IS_INSERT = "is_insert";
    public static final String IS_EDIT = "is_edit";
    public static final String IS_LIST = "is_list";
    public static final String IS_QUERY = "is_query";
    public static final String QUERY_TYPE = "query_type";
    public static final String HTML_TYPE = "html_type";
    public static final String DICT_TYPE = "dict_type";
    public static final String SORT = "sort";
    public static final String CREATE_BY = "create_by";
    public static final String CREATE_TIME = "create_time";

    /**
     * 默认构造函数
     */
    public S_gen_column_mapper(S_gen_column s_gen_column) {
        if (s_gen_column == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_gen_column.isset_column_id) {
            this.setColumn_id(s_gen_column.getColumn_id());
        }
        //普通属性
        if (s_gen_column.isset_table_id) {
            this.setTable_id(s_gen_column.getTable_id());
        }
        if (s_gen_column.isset_column_name) {
            this.setColumn_name(s_gen_column.getColumn_name());
        }
        if (s_gen_column.isset_column_comment) {
            this.setColumn_comment(s_gen_column.getColumn_comment());
        }
        if (s_gen_column.isset_column_type) {
            this.setColumn_type(s_gen_column.getColumn_type());
        }
        if (s_gen_column.isset_java_type) {
            this.setJava_type(s_gen_column.getJava_type());
        }
        if (s_gen_column.isset_java_field) {
            this.setJava_field(s_gen_column.getJava_field());
        }
        if (s_gen_column.isset_is_pk) {
            this.setIs_pk(s_gen_column.getIs_pk());
        }
        if (s_gen_column.isset_is_increment) {
            this.setIs_increment(s_gen_column.getIs_increment());
        }
        if (s_gen_column.isset_is_required) {
            this.setIs_required(s_gen_column.getIs_required());
        }
        if (s_gen_column.isset_is_insert) {
            this.setIs_insert(s_gen_column.getIs_insert());
        }
        if (s_gen_column.isset_is_edit) {
            this.setIs_edit(s_gen_column.getIs_edit());
        }
        if (s_gen_column.isset_is_list) {
            this.setIs_list(s_gen_column.getIs_list());
        }
        if (s_gen_column.isset_is_query) {
            this.setIs_query(s_gen_column.getIs_query());
        }
        if (s_gen_column.isset_query_type) {
            this.setQuery_type(s_gen_column.getQuery_type());
        }
        if (s_gen_column.isset_html_type) {
            this.setHtml_type(s_gen_column.getHtml_type());
        }
        if (s_gen_column.isset_dict_type) {
            this.setDict_type(s_gen_column.getDict_type());
        }
        if (s_gen_column.isset_sort) {
            this.setSort(s_gen_column.getSort());
        }
        if (s_gen_column.isset_create_by) {
            this.setCreate_by(s_gen_column.getCreate_by());
        }
        if (s_gen_column.isset_create_time) {
            this.setCreate_time(s_gen_column.getCreate_time());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_gen_column.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_gen_column";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return COLUMN_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getColumn_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(COLUMN_ID, this.getColumn_id());
        ib.set(TABLE_ID, this.getTable_id(), this.isset_table_id);
        ib.set(COLUMN_NAME, this.getColumn_name(), this.isset_column_name);
        ib.set(COLUMN_COMMENT, this.getColumn_comment(), this.isset_column_comment);
        ib.set(COLUMN_TYPE, this.getColumn_type(), this.isset_column_type);
        ib.set(JAVA_TYPE, this.getJava_type(), this.isset_java_type);
        ib.set(JAVA_FIELD, this.getJava_field(), this.isset_java_field);
        ib.set(IS_PK, this.getIs_pk(), this.isset_is_pk);
        ib.set(IS_INCREMENT, this.getIs_increment(), this.isset_is_increment);
        ib.set(IS_REQUIRED, this.getIs_required(), this.isset_is_required);
        ib.set(IS_INSERT, this.getIs_insert(), this.isset_is_insert);
        ib.set(IS_EDIT, this.getIs_edit(), this.isset_is_edit);
        ib.set(IS_LIST, this.getIs_list(), this.isset_is_list);
        ib.set(IS_QUERY, this.getIs_query(), this.isset_is_query);
        ib.set(QUERY_TYPE, this.getQuery_type(), this.isset_query_type);
        ib.set(HTML_TYPE, this.getHtml_type(), this.isset_html_type);
        ib.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ib.set(SORT, this.getSort(), this.isset_sort);
        ib.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TABLE_ID, this.getTable_id(), this.isset_table_id);
        ub.set(COLUMN_NAME, this.getColumn_name(), this.isset_column_name);
        ub.set(COLUMN_COMMENT, this.getColumn_comment(), this.isset_column_comment);
        ub.set(COLUMN_TYPE, this.getColumn_type(), this.isset_column_type);
        ub.set(JAVA_TYPE, this.getJava_type(), this.isset_java_type);
        ub.set(JAVA_FIELD, this.getJava_field(), this.isset_java_field);
        ub.set(IS_PK, this.getIs_pk(), this.isset_is_pk);
        ub.set(IS_INCREMENT, this.getIs_increment(), this.isset_is_increment);
        ub.set(IS_REQUIRED, this.getIs_required(), this.isset_is_required);
        ub.set(IS_INSERT, this.getIs_insert(), this.isset_is_insert);
        ub.set(IS_EDIT, this.getIs_edit(), this.isset_is_edit);
        ub.set(IS_LIST, this.getIs_list(), this.isset_is_list);
        ub.set(IS_QUERY, this.getIs_query(), this.isset_is_query);
        ub.set(QUERY_TYPE, this.getQuery_type(), this.isset_query_type);
        ub.set(HTML_TYPE, this.getHtml_type(), this.isset_html_type);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TABLE_ID, this.getTable_id(), this.isset_table_id);
        ub.set(COLUMN_NAME, this.getColumn_name(), this.isset_column_name);
        ub.set(COLUMN_COMMENT, this.getColumn_comment(), this.isset_column_comment);
        ub.set(COLUMN_TYPE, this.getColumn_type(), this.isset_column_type);
        ub.set(JAVA_TYPE, this.getJava_type(), this.isset_java_type);
        ub.set(JAVA_FIELD, this.getJava_field(), this.isset_java_field);
        ub.set(IS_PK, this.getIs_pk(), this.isset_is_pk);
        ub.set(IS_INCREMENT, this.getIs_increment(), this.isset_is_increment);
        ub.set(IS_REQUIRED, this.getIs_required(), this.isset_is_required);
        ub.set(IS_INSERT, this.getIs_insert(), this.isset_is_insert);
        ub.set(IS_EDIT, this.getIs_edit(), this.isset_is_edit);
        ub.set(IS_LIST, this.getIs_list(), this.isset_is_list);
        ub.set(IS_QUERY, this.getIs_query(), this.isset_is_query);
        ub.set(QUERY_TYPE, this.getQuery_type(), this.isset_query_type);
        ub.set(HTML_TYPE, this.getHtml_type(), this.isset_html_type);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TABLE_ID, this.getTable_id(), this.isset_table_id);
        ub.set(COLUMN_NAME, this.getColumn_name(), this.isset_column_name);
        ub.set(COLUMN_COMMENT, this.getColumn_comment(), this.isset_column_comment);
        ub.set(COLUMN_TYPE, this.getColumn_type(), this.isset_column_type);
        ub.set(JAVA_TYPE, this.getJava_type(), this.isset_java_type);
        ub.set(JAVA_FIELD, this.getJava_field(), this.isset_java_field);
        ub.set(IS_PK, this.getIs_pk(), this.isset_is_pk);
        ub.set(IS_INCREMENT, this.getIs_increment(), this.isset_is_increment);
        ub.set(IS_REQUIRED, this.getIs_required(), this.isset_is_required);
        ub.set(IS_INSERT, this.getIs_insert(), this.isset_is_insert);
        ub.set(IS_EDIT, this.getIs_edit(), this.isset_is_edit);
        ub.set(IS_LIST, this.getIs_list(), this.isset_is_list);
        ub.set(IS_QUERY, this.getIs_query(), this.isset_is_query);
        ub.set(QUERY_TYPE, this.getQuery_type(), this.isset_query_type);
        ub.set(HTML_TYPE, this.getHtml_type(), this.isset_html_type);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select column_id, table_id, column_name, column_comment, column_type, java_type, java_field, is_pk, is_increment, is_required, is_insert, is_edit, is_list, is_query, query_type, html_type, dict_type, sort, create_by, create_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select column_id, table_id, column_name, column_comment, column_type, java_type, java_field, is_pk, is_increment, is_required, is_insert, is_edit, is_list, is_query, query_type, html_type, dict_type, sort, create_by, create_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_gen_column mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_gen_column toS_gen_column() {
        return super.$clone();
    }
}

/**
 * s_gen_column RowMapper
 *
 * @author genrator
 */
class S_gen_columnRowMapper implements RowMapper<S_gen_column> {

    @Override
    public S_gen_column mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_gen_column s_gen_column = new S_gen_column();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.COLUMN_ID);
        if (columnIndex > 0) {
            s_gen_column.setColumn_id(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.TABLE_ID);
        if (columnIndex > 0) {
            s_gen_column.setTable_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.COLUMN_NAME);
        if (columnIndex > 0) {
            s_gen_column.setColumn_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.COLUMN_COMMENT);
        if (columnIndex > 0) {
            s_gen_column.setColumn_comment(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.COLUMN_TYPE);
        if (columnIndex > 0) {
            s_gen_column.setColumn_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.JAVA_TYPE);
        if (columnIndex > 0) {
            s_gen_column.setJava_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.JAVA_FIELD);
        if (columnIndex > 0) {
            s_gen_column.setJava_field(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.IS_PK);
        if (columnIndex > 0) {
            s_gen_column.setIs_pk(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.IS_INCREMENT);
        if (columnIndex > 0) {
            s_gen_column.setIs_increment(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.IS_REQUIRED);
        if (columnIndex > 0) {
            s_gen_column.setIs_required(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.IS_INSERT);
        if (columnIndex > 0) {
            s_gen_column.setIs_insert(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.IS_EDIT);
        if (columnIndex > 0) {
            s_gen_column.setIs_edit(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.IS_LIST);
        if (columnIndex > 0) {
            s_gen_column.setIs_list(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.IS_QUERY);
        if (columnIndex > 0) {
            s_gen_column.setIs_query(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.QUERY_TYPE);
        if (columnIndex > 0) {
            s_gen_column.setQuery_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.HTML_TYPE);
        if (columnIndex > 0) {
            s_gen_column.setHtml_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.DICT_TYPE);
        if (columnIndex > 0) {
            s_gen_column.setDict_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.SORT);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_gen_column.setSort(null);
            } else {
                s_gen_column.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.CREATE_BY);
        if (columnIndex > 0) {
            s_gen_column.setCreate_by(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_column_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_gen_column.setCreate_time(null);
            } else {
                s_gen_column.setCreate_time(rs.getLong(columnIndex));
            }
        }
        return s_gen_column;
    }
}
