package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_GEN_TABLE *
 * @author genrator
 */
public class S_gen_table_mapper extends S_gen_table implements BaseMapper<S_gen_table> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_gen_table> ROW_MAPPER = new S_gen_tableRowMapper();

    // 主键
    public static final String TABLE_ID = "table_id";
    // 普通属性
    public static final String TABLE_NAME = "table_name";
    public static final String TABLE_COMMENT = "table_comment";
    public static final String SUB_TABLE_NAME = "sub_table_name";
    public static final String SUB_TABLE_FK_NAME = "sub_table_fk_name";
    public static final String CLASS_NAME = "class_name";
    public static final String TPL_CATEGORY = "tpl_category";
    public static final String PACKAGE_NAME = "package_name";
    public static final String MODULE_NAME = "module_name";
    public static final String BUSINESS_NAME = "business_name";
    public static final String FUNCTION_NAME = "function_name";
    public static final String FUNCTION_AUTHOR = "function_author";
    public static final String GEN_TYPE = "gen_type";
    public static final String GEN_PATH = "gen_path";
    public static final String OPTIONS = "options";
    public static final String CREATE_BY = "create_by";
    public static final String CREATE_TIME = "create_time";
    public static final String REMARK = "remark";

    /**
     * 默认构造函数
     */
    public S_gen_table_mapper(S_gen_table s_gen_table) {
        if (s_gen_table == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_gen_table.isset_table_id) {
            this.setTable_id(s_gen_table.getTable_id());
        }
        //普通属性
        if (s_gen_table.isset_table_name) {
            this.setTable_name(s_gen_table.getTable_name());
        }
        if (s_gen_table.isset_table_comment) {
            this.setTable_comment(s_gen_table.getTable_comment());
        }
        if (s_gen_table.isset_sub_table_name) {
            this.setSub_table_name(s_gen_table.getSub_table_name());
        }
        if (s_gen_table.isset_sub_table_fk_name) {
            this.setSub_table_fk_name(s_gen_table.getSub_table_fk_name());
        }
        if (s_gen_table.isset_class_name) {
            this.setClass_name(s_gen_table.getClass_name());
        }
        if (s_gen_table.isset_tpl_category) {
            this.setTpl_category(s_gen_table.getTpl_category());
        }
        if (s_gen_table.isset_package_name) {
            this.setPackage_name(s_gen_table.getPackage_name());
        }
        if (s_gen_table.isset_module_name) {
            this.setModule_name(s_gen_table.getModule_name());
        }
        if (s_gen_table.isset_business_name) {
            this.setBusiness_name(s_gen_table.getBusiness_name());
        }
        if (s_gen_table.isset_function_name) {
            this.setFunction_name(s_gen_table.getFunction_name());
        }
        if (s_gen_table.isset_function_author) {
            this.setFunction_author(s_gen_table.getFunction_author());
        }
        if (s_gen_table.isset_gen_type) {
            this.setGen_type(s_gen_table.getGen_type());
        }
        if (s_gen_table.isset_gen_path) {
            this.setGen_path(s_gen_table.getGen_path());
        }
        if (s_gen_table.isset_options) {
            this.setOptions(s_gen_table.getOptions());
        }
        if (s_gen_table.isset_create_by) {
            this.setCreate_by(s_gen_table.getCreate_by());
        }
        if (s_gen_table.isset_create_time) {
            this.setCreate_time(s_gen_table.getCreate_time());
        }
        if (s_gen_table.isset_remark) {
            this.setRemark(s_gen_table.getRemark());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_gen_table.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_gen_table";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return TABLE_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getTable_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(TABLE_ID, this.getTable_id());
        ib.set(TABLE_NAME, this.getTable_name(), this.isset_table_name);
        ib.set(TABLE_COMMENT, this.getTable_comment(), this.isset_table_comment);
        ib.set(SUB_TABLE_NAME, this.getSub_table_name(), this.isset_sub_table_name);
        ib.set(SUB_TABLE_FK_NAME, this.getSub_table_fk_name(), this.isset_sub_table_fk_name);
        ib.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ib.set(TPL_CATEGORY, this.getTpl_category(), this.isset_tpl_category);
        ib.set(PACKAGE_NAME, this.getPackage_name(), this.isset_package_name);
        ib.set(MODULE_NAME, this.getModule_name(), this.isset_module_name);
        ib.set(BUSINESS_NAME, this.getBusiness_name(), this.isset_business_name);
        ib.set(FUNCTION_NAME, this.getFunction_name(), this.isset_function_name);
        ib.set(FUNCTION_AUTHOR, this.getFunction_author(), this.isset_function_author);
        ib.set(GEN_TYPE, this.getGen_type(), this.isset_gen_type);
        ib.set(GEN_PATH, this.getGen_path(), this.isset_gen_path);
        ib.set(OPTIONS, this.getOptions(), this.isset_options);
        ib.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(REMARK, this.getRemark(), this.isset_remark);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TABLE_NAME, this.getTable_name(), this.isset_table_name);
        ub.set(TABLE_COMMENT, this.getTable_comment(), this.isset_table_comment);
        ub.set(SUB_TABLE_NAME, this.getSub_table_name(), this.isset_sub_table_name);
        ub.set(SUB_TABLE_FK_NAME, this.getSub_table_fk_name(), this.isset_sub_table_fk_name);
        ub.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ub.set(TPL_CATEGORY, this.getTpl_category(), this.isset_tpl_category);
        ub.set(PACKAGE_NAME, this.getPackage_name(), this.isset_package_name);
        ub.set(MODULE_NAME, this.getModule_name(), this.isset_module_name);
        ub.set(BUSINESS_NAME, this.getBusiness_name(), this.isset_business_name);
        ub.set(FUNCTION_NAME, this.getFunction_name(), this.isset_function_name);
        ub.set(FUNCTION_AUTHOR, this.getFunction_author(), this.isset_function_author);
        ub.set(GEN_TYPE, this.getGen_type(), this.isset_gen_type);
        ub.set(GEN_PATH, this.getGen_path(), this.isset_gen_path);
        ub.set(OPTIONS, this.getOptions(), this.isset_options);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TABLE_NAME, this.getTable_name(), this.isset_table_name);
        ub.set(TABLE_COMMENT, this.getTable_comment(), this.isset_table_comment);
        ub.set(SUB_TABLE_NAME, this.getSub_table_name(), this.isset_sub_table_name);
        ub.set(SUB_TABLE_FK_NAME, this.getSub_table_fk_name(), this.isset_sub_table_fk_name);
        ub.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ub.set(TPL_CATEGORY, this.getTpl_category(), this.isset_tpl_category);
        ub.set(PACKAGE_NAME, this.getPackage_name(), this.isset_package_name);
        ub.set(MODULE_NAME, this.getModule_name(), this.isset_module_name);
        ub.set(BUSINESS_NAME, this.getBusiness_name(), this.isset_business_name);
        ub.set(FUNCTION_NAME, this.getFunction_name(), this.isset_function_name);
        ub.set(FUNCTION_AUTHOR, this.getFunction_author(), this.isset_function_author);
        ub.set(GEN_TYPE, this.getGen_type(), this.isset_gen_type);
        ub.set(GEN_PATH, this.getGen_path(), this.isset_gen_path);
        ub.set(OPTIONS, this.getOptions(), this.isset_options);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TABLE_NAME, this.getTable_name(), this.isset_table_name);
        ub.set(TABLE_COMMENT, this.getTable_comment(), this.isset_table_comment);
        ub.set(SUB_TABLE_NAME, this.getSub_table_name(), this.isset_sub_table_name);
        ub.set(SUB_TABLE_FK_NAME, this.getSub_table_fk_name(), this.isset_sub_table_fk_name);
        ub.set(CLASS_NAME, this.getClass_name(), this.isset_class_name);
        ub.set(TPL_CATEGORY, this.getTpl_category(), this.isset_tpl_category);
        ub.set(PACKAGE_NAME, this.getPackage_name(), this.isset_package_name);
        ub.set(MODULE_NAME, this.getModule_name(), this.isset_module_name);
        ub.set(BUSINESS_NAME, this.getBusiness_name(), this.isset_business_name);
        ub.set(FUNCTION_NAME, this.getFunction_name(), this.isset_function_name);
        ub.set(FUNCTION_AUTHOR, this.getFunction_author(), this.isset_function_author);
        ub.set(GEN_TYPE, this.getGen_type(), this.isset_gen_type);
        ub.set(GEN_PATH, this.getGen_path(), this.isset_gen_path);
        ub.set(OPTIONS, this.getOptions(), this.isset_options);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select table_id, table_name, table_comment, sub_table_name, sub_table_fk_name, class_name, tpl_category, package_name, module_name, business_name, function_name, function_author, gen_type, gen_path, options, create_by, create_time, remark from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select table_id, table_name, table_comment, sub_table_name, sub_table_fk_name, class_name, tpl_category, package_name, module_name, business_name, function_name, function_author, gen_type, gen_path, options, create_by, create_time, remark from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_gen_table mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_gen_table toS_gen_table() {
        return super.$clone();
    }
}

/**
 * s_gen_table RowMapper
 *
 * @author genrator
 */
class S_gen_tableRowMapper implements RowMapper<S_gen_table> {

    @Override
    public S_gen_table mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_gen_table s_gen_table = new S_gen_table();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.TABLE_ID);
        if (columnIndex > 0) {
            s_gen_table.setTable_id(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.TABLE_NAME);
        if (columnIndex > 0) {
            s_gen_table.setTable_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.TABLE_COMMENT);
        if (columnIndex > 0) {
            s_gen_table.setTable_comment(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.SUB_TABLE_NAME);
        if (columnIndex > 0) {
            s_gen_table.setSub_table_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.SUB_TABLE_FK_NAME);
        if (columnIndex > 0) {
            s_gen_table.setSub_table_fk_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.CLASS_NAME);
        if (columnIndex > 0) {
            s_gen_table.setClass_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.TPL_CATEGORY);
        if (columnIndex > 0) {
            s_gen_table.setTpl_category(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.PACKAGE_NAME);
        if (columnIndex > 0) {
            s_gen_table.setPackage_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.MODULE_NAME);
        if (columnIndex > 0) {
            s_gen_table.setModule_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.BUSINESS_NAME);
        if (columnIndex > 0) {
            s_gen_table.setBusiness_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.FUNCTION_NAME);
        if (columnIndex > 0) {
            s_gen_table.setFunction_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.FUNCTION_AUTHOR);
        if (columnIndex > 0) {
            s_gen_table.setFunction_author(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.GEN_TYPE);
        if (columnIndex > 0) {
            s_gen_table.setGen_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.GEN_PATH);
        if (columnIndex > 0) {
            s_gen_table.setGen_path(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.OPTIONS);
        if (columnIndex > 0) {
            s_gen_table.setOptions(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.CREATE_BY);
        if (columnIndex > 0) {
            s_gen_table.setCreate_by(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_gen_table.setCreate_time(null);
            } else {
                s_gen_table.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_gen_table_mapper.REMARK);
        if (columnIndex > 0) {
            s_gen_table.setRemark(rs.getString(columnIndex));
        }
        return s_gen_table;
    }
}
