package com.iplatform.openocr;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.TextBlock;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class RestTemplateOcrEngine extends AbstractOcrEngine{
//   @Override
//    protected List<TableConfig> loadTableConfigs() {
//        return null;
//    }

    private RestTemplate restTemplate = new RestTemplate();

    @Override
    public List<TextBlock> recognize(String id, String imgBase64) {
        if(StringUtils.isEmpty(id) || StringUtils.isEmpty(imgBase64)){
            logger.error("调用ocr服务，请求数据为空: id | img");
            return null;
        }
        Request request = new Request();
        request.setId(id);
        request.setImg(imgBase64);

        ResponseEntity<String> entity = restTemplate.postForEntity(this.getRemoteUrl(), request, String.class);
        if(entity != null){
//            List<?> list = entity.getBody();
            String jsonData = entity.getBody();
            logger.debug(jsonData);
            if(StringUtils.isEmpty(jsonData)){
                return null;
            }

            List<TextBlock> data = new ArrayList<>();

            try {
//                logger.debug(jsonData);
                List<Object> list = JsonUtils.jsonStringToObject(jsonData, List.class);
                for(Object obj : list){
                    data.add(this.transferToTextBlock((Map<String, Object>) obj));
                }
                logger.debug("++++++ 请求返回 TextBlock: " + data.size());
                return data;

            } catch (Exception e) {
                logger.error("解析json结果错误:" + jsonData, e);
                return data;
            }
        }
        return null;
    }

    private TextBlock transferToTextBlock(Map<String, Object> map){
        TextBlock textBlock = new TextBlock();
        textBlock.setText(map.get("name").toString());
        textBlock.setScore(Float.parseFloat(map.get("score").toString()));
        textBlock.setStartPosition(new float[]{Float.parseFloat(map.get("x1").toString()), Float.parseFloat(map.get("y1").toString())});
        textBlock.setEndPosition(new float[]{Float.parseFloat(map.get("x2").toString()), Float.parseFloat(map.get("y2").toString())});
        return textBlock;
    }
}
