/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.openocr;

import com.iplatform.openocr.AbstractOcrEngine;
import com.iplatform.openocr.Request;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.TextBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public abstract class RestTemplateOcrEngine
extends AbstractOcrEngine {
    private RestTemplate restTemplate = new RestTemplate();

    @Override
    public List<TextBlock> recognize(String id, String imgBase64) {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)imgBase64)) {
            this.logger.error("\u8c03\u7528ocr\u670d\u52a1\uff0c\u8bf7\u6c42\u6570\u636e\u4e3a\u7a7a: id | img");
            return null;
        }
        Request request = new Request();
        request.setId(id);
        request.setImg(imgBase64);
        ResponseEntity entity = this.restTemplate.postForEntity(this.getRemoteUrl(), (Object)request, String.class, new Object[0]);
        if (entity != null) {
            String jsonData = (String)entity.getBody();
            this.logger.debug(jsonData);
            if (StringUtils.isEmpty((String)jsonData)) {
                return null;
            }
            ArrayList<TextBlock> data = new ArrayList<TextBlock>();
            try {
                List list = (List)JsonUtils.jsonStringToObject((String)jsonData, List.class);
                for (Object obj : list) {
                    data.add(this.transferToTextBlock((Map)obj));
                }
                this.logger.debug("++++++ \u8bf7\u6c42\u8fd4\u56de TextBlock: " + data.size());
                return data;
            }
            catch (Exception e) {
                this.logger.error("\u89e3\u6790json\u7ed3\u679c\u9519\u8bef:" + jsonData, (Throwable)e);
                return data;
            }
        }
        return null;
    }

    private TextBlock transferToTextBlock(Map<String, Object> map) {
        TextBlock textBlock = new TextBlock();
        textBlock.setText(map.get("name").toString());
        textBlock.setScore(Float.parseFloat(map.get("score").toString()));
        textBlock.setStartPosition(new float[]{Float.parseFloat(map.get("x1").toString()), Float.parseFloat(map.get("y1").toString())});
        textBlock.setEndPosition(new float[]{Float.parseFloat(map.get("x2").toString()), Float.parseFloat(map.get("y2").toString())});
        return textBlock;
    }
}

