package com.iplatform.openocr;

import com.walker.openocr.OcrType;
import com.walker.openocr.TextBlock;
import com.walker.openocr.TextResolver;
import com.walker.openocr.table.TableConfig;

import java.util.List;

/**
 * OCR引擎服务对象，提供调用以及解析文本方法。
 * @author 时克英
 * @date 2022-09-02
 */
public interface OcrEngine {

    /**
     * 设置远程识别地址
     * @param url
     */
    void setRemoteUrl(String url);

    /**
     * 根据识别类型，返回配置的识别解析器
     * @param ocrType
     * @return
     */
    TextResolver<?,?> getTextResolver(OcrType ocrType);

    /**
     * 调用请求识别图片，并转换为文本块集合
     * @param id
     * @param imgBase64
     * @return
     */
    List<TextBlock> recognize(String id, String imgBase64);

    /**
     * 引擎初始化启动
     */
    void startup();

    List<TableConfig> getTableConfigList();
}
