/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.openocr;

import com.iplatform.openocr.OcrEngine;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.OcrType;
import com.walker.openocr.TextBlock;
import com.walker.openocr.TextResolver;
import com.walker.openocr.idcard.IdCardTextResolver;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.table.TableTextResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOcrEngine
implements OcrEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String remoteUrl = null;
    private List<TableConfig> tableConfigList = new ArrayList<TableConfig>(8);
    private Map<String, TextResolver<?, ?>> textResolverMap = new HashMap();

    @Override
    public void setRemoteUrl(String url) {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("OCR\u8fdc\u7a0b\u670d\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.remoteUrl = url;
    }

    @Override
    public TextResolver<?, ?> getTextResolver(OcrType ocrType) {
        TextResolver<?, ?> textResolver = this.textResolverMap.get(ocrType.getIndex());
        if (textResolver == null) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u6307\u5b9a\u7684\u6587\u672c\u89e3\u6790\u5668:" + ocrType);
        }
        return textResolver;
    }

    @Override
    public List<TextBlock> recognize(String id, String imgBase64) {
        return null;
    }

    @Override
    public void startup() {
        List<TableConfig> tableConfigs = this.loadTableConfigs();
        if (StringUtils.isEmptyList(tableConfigs)) {
            this.logger.warn("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55 TableConfig");
        } else {
            this.tableConfigList.addAll(tableConfigs);
            this.logger.info("\u52a0\u8f7d TableConfig \u6570\u91cf:" + this.tableConfigList.size());
        }
        if (this.tableConfigList.size() > 0) {
            TableTextResolver tableTextResolver = new TableTextResolver();
            this.textResolverMap.put("table", (TextResolver<?, ?>)tableTextResolver);
        }
        IdCardTextResolver idCardTextResolver = new IdCardTextResolver();
        this.textResolverMap.put("id_card", (TextResolver<?, ?>)idCardTextResolver);
    }

    protected String getRemoteUrl() {
        return this.remoteUrl;
    }

    @Override
    public List<TableConfig> getTableConfigList() {
        return this.tableConfigList;
    }

    protected abstract List<TableConfig> loadTableConfigs();
}

