package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_CHAT *
 * @author genrator
 */
public class S_chat_mapper extends S_chat implements BaseMapper<S_chat> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_chat> ROW_MAPPER = new S_chatRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String CREATE_TIME = "create_time";
    public static final String ME = "me";
    public static final String USER_ID = "user_id";
    public static final String TYPE = "type";
    public static final String MSG_TYPE = "msg_type";
    public static final String MESSAGE = "message";
    public static final String BIZ_ID = "biz_id";

    /**
     * 默认构造函数
     */
    public S_chat_mapper(S_chat s_chat) {
        if (s_chat == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_chat.isset_id) {
            this.setId(s_chat.getId());
        }
        //普通属性
        if (s_chat.isset_create_time) {
            this.setCreate_time(s_chat.getCreate_time());
        }
        if (s_chat.isset_me) {
            this.setMe(s_chat.getMe());
        }
        if (s_chat.isset_user_id) {
            this.setUser_id(s_chat.getUser_id());
        }
        if (s_chat.isset_type) {
            this.setType(s_chat.getType());
        }
        if (s_chat.isset_msg_type) {
            this.setMsg_type(s_chat.getMsg_type());
        }
        if (s_chat.isset_message) {
            this.setMessage(s_chat.getMessage());
        }
        if (s_chat.isset_biz_id) {
            this.setBiz_id(s_chat.getBiz_id());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_chat.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_chat";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(ME, this.getMe(), this.isset_me);
        ib.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ib.set(TYPE, this.getType(), this.isset_type);
        ib.set(MSG_TYPE, this.getMsg_type(), this.isset_msg_type);
        ib.set(MESSAGE, this.getMessage(), this.isset_message);
        ib.set(BIZ_ID, this.getBiz_id(), this.isset_biz_id);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(ME, this.getMe(), this.isset_me);
        ub.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(MSG_TYPE, this.getMsg_type(), this.isset_msg_type);
        ub.set(MESSAGE, this.getMessage(), this.isset_message);
        ub.set(BIZ_ID, this.getBiz_id(), this.isset_biz_id);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(ME, this.getMe(), this.isset_me);
        ub.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(MSG_TYPE, this.getMsg_type(), this.isset_msg_type);
        ub.set(MESSAGE, this.getMessage(), this.isset_message);
        ub.set(BIZ_ID, this.getBiz_id(), this.isset_biz_id);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(ME, this.getMe(), this.isset_me);
        ub.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(MSG_TYPE, this.getMsg_type(), this.isset_msg_type);
        ub.set(MESSAGE, this.getMessage(), this.isset_message);
        ub.set(BIZ_ID, this.getBiz_id(), this.isset_biz_id);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, me, user_id, type, msg_type, message, biz_id from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, me, user_id, type, msg_type, message, biz_id from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_chat mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_chat toS_chat() {
        return super.$clone();
    }
}

/**
 * s_chat RowMapper
 *
 * @author genrator
 */
class S_chatRowMapper implements RowMapper<S_chat> {

    @Override
    public S_chat mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_chat s_chat = new S_chat();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.ID);
        if (columnIndex > 0) {
            s_chat.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_chat.setCreate_time(null);
            } else {
                s_chat.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.ME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_chat.setMe(null);
            } else {
                s_chat.setMe(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.USER_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_chat.setUser_id(null);
            } else {
                s_chat.setUser_id(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_chat.setType(null);
            } else {
                s_chat.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.MSG_TYPE);
        if (columnIndex > 0) {
            s_chat.setMsg_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.MESSAGE);
        if (columnIndex > 0) {
            s_chat.setMessage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_chat_mapper.BIZ_ID);
        if (columnIndex > 0) {
            s_chat.setBiz_id(rs.getString(columnIndex));
        }
        return s_chat;
    }
}
