package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_CLASS_EXT *
 * @author genrator
 */
public class S_class_ext_mapper extends S_class_ext implements BaseMapper<S_class_ext> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_class_ext> ROW_MAPPER = new S_class_extRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String TYPE = "type";

    /**
     * 默认构造函数
     */
    public S_class_ext_mapper(S_class_ext s_class_ext) {
        if (s_class_ext == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_class_ext.isset_id) {
            this.setId(s_class_ext.getId());
        }
        //普通属性
        if (s_class_ext.isset_name) {
            this.setName(s_class_ext.getName());
        }
        if (s_class_ext.isset_description) {
            this.setDescription(s_class_ext.getDescription());
        }
        if (s_class_ext.isset_type) {
            this.setType(s_class_ext.getType());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_class_ext.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_class_ext";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(NAME, this.getName(), this.isset_name);
        ib.set(DESCRIPTION, this.getDescription(), this.isset_description);
        ib.set(TYPE, this.getType(), this.isset_type);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(DESCRIPTION, this.getDescription(), this.isset_description);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(DESCRIPTION, this.getDescription(), this.isset_description);
        ub.set(TYPE, this.getType(), this.isset_type);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(DESCRIPTION, this.getDescription(), this.isset_description);
        ub.set(TYPE, this.getType(), this.isset_type);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, name, description, type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, name, description, type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_class_ext mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_class_ext toS_class_ext() {
        return super.$clone();
    }
}

/**
 * s_class_ext RowMapper
 *
 * @author genrator
 */
class S_class_extRowMapper implements RowMapper<S_class_ext> {

    @Override
    public S_class_ext mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_class_ext s_class_ext = new S_class_ext();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_class_ext_mapper.ID);
        if (columnIndex > 0) {
            s_class_ext.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_class_ext_mapper.NAME);
        if (columnIndex > 0) {
            s_class_ext.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_class_ext_mapper.DESCRIPTION);
        if (columnIndex > 0) {
            s_class_ext.setDescription(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_class_ext_mapper.TYPE);
        if (columnIndex > 0) {
            s_class_ext.setType(rs.getString(columnIndex));
        }
        return s_class_ext;
    }
}
