package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_CODE *
 * @author genrator
 */
public class S_code_mapper extends S_code implements BaseMapper<S_code> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_code> ROW_MAPPER = new S_codeRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String SXH = "sxh";
    public static final String NAME = "name";
    public static final String CODE_ID = "code_id";
    public static final String CODE_TYPE = "code_type";
    public static final String PARENT_ID = "parent_id";
    public static final String CODE_SEC = "code_sec";
    public static final String CHILD_SUM = "child_sum";

    /**
     * 默认构造函数
     */
    public S_code_mapper(S_code s_code) {
        if (s_code == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_code.isset_id) {
            this.setId(s_code.getId());
        }
        //普通属性
        if (s_code.isset_sxh) {
            this.setSxh(s_code.getSxh());
        }
        if (s_code.isset_name) {
            this.setName(s_code.getName());
        }
        if (s_code.isset_code_id) {
            this.setCode_id(s_code.getCode_id());
        }
        if (s_code.isset_code_type) {
            this.setCode_type(s_code.getCode_type());
        }
        if (s_code.isset_parent_id) {
            this.setParent_id(s_code.getParent_id());
        }
        if (s_code.isset_code_sec) {
            this.setCode_sec(s_code.getCode_sec());
        }
        if (s_code.isset_child_sum) {
            this.setChild_sum(s_code.getChild_sum());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_code.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_code";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(SXH, this.getSxh(), this.isset_sxh);
        ib.set(NAME, this.getName(), this.isset_name);
        ib.set(CODE_ID, this.getCode_id(), this.isset_code_id);
        ib.set(CODE_TYPE, this.getCode_type(), this.isset_code_type);
        ib.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ib.set(CODE_SEC, this.getCode_sec(), this.isset_code_sec);
        ib.set(CHILD_SUM, this.getChild_sum(), this.isset_child_sum);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(SXH, this.getSxh(), this.isset_sxh);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(CODE_ID, this.getCode_id(), this.isset_code_id);
        ub.set(CODE_TYPE, this.getCode_type(), this.isset_code_type);
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(CODE_SEC, this.getCode_sec(), this.isset_code_sec);
        ub.set(CHILD_SUM, this.getChild_sum(), this.isset_child_sum);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(SXH, this.getSxh(), this.isset_sxh);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(CODE_ID, this.getCode_id(), this.isset_code_id);
        ub.set(CODE_TYPE, this.getCode_type(), this.isset_code_type);
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(CODE_SEC, this.getCode_sec(), this.isset_code_sec);
        ub.set(CHILD_SUM, this.getChild_sum(), this.isset_child_sum);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(SXH, this.getSxh(), this.isset_sxh);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(CODE_ID, this.getCode_id(), this.isset_code_id);
        ub.set(CODE_TYPE, this.getCode_type(), this.isset_code_type);
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(CODE_SEC, this.getCode_sec(), this.isset_code_sec);
        ub.set(CHILD_SUM, this.getChild_sum(), this.isset_child_sum);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, sxh, name, code_id, code_type, parent_id, code_sec, child_sum from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, sxh, name, code_id, code_type, parent_id, code_sec, child_sum from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_code mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_code toS_code() {
        return super.$clone();
    }
}

/**
 * s_code RowMapper
 *
 * @author genrator
 */
class S_codeRowMapper implements RowMapper<S_code> {

    @Override
    public S_code mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_code s_code = new S_code();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.ID);
        if (columnIndex > 0) {
            s_code.setId(rs.getString(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.SXH);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_code.setSxh(null);
            } else {
                s_code.setSxh(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.NAME);
        if (columnIndex > 0) {
            s_code.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.CODE_ID);
        if (columnIndex > 0) {
            s_code.setCode_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.CODE_TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_code.setCode_type(null);
            } else {
                s_code.setCode_type(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.PARENT_ID);
        if (columnIndex > 0) {
            s_code.setParent_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.CODE_SEC);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_code.setCode_sec(null);
            } else {
                s_code.setCode_sec(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_code_mapper.CHILD_SUM);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_code.setChild_sum(null);
            } else {
                s_code.setChild_sum(rs.getInt(columnIndex));
            }
        }
        return s_code;
    }
}
