package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_CONFIG *
 * @author genrator
 */
public class S_config_mapper extends S_config implements BaseMapper<S_config> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_config> ROW_MAPPER = new S_configRowMapper();

    // 主键
    public static final String CONFIG_ID = "config_id";
    // 普通属性
    public static final String CONFIG_NAME = "config_name";
    public static final String CONFIG_KEY = "config_key";
    public static final String CONFIG_VALUE = "config_value";
    public static final String CONFIG_TYPE = "config_type";
    public static final String CREATE_TIME = "create_time";
    public static final String REMARK = "remark";
    public static final String DATA_TYPE = "data_type";
    public static final String GROUP_ID = "group_id";
    public static final String FORM_ID = "form_id";

    /**
     * 默认构造函数
     */
    public S_config_mapper(S_config s_config) {
        if (s_config == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_config.isset_config_id) {
            this.setConfig_id(s_config.getConfig_id());
        }
        //普通属性
        if (s_config.isset_config_name) {
            this.setConfig_name(s_config.getConfig_name());
        }
        if (s_config.isset_config_key) {
            this.setConfig_key(s_config.getConfig_key());
        }
        if (s_config.isset_config_value) {
            this.setConfig_value(s_config.getConfig_value());
        }
        if (s_config.isset_config_type) {
            this.setConfig_type(s_config.getConfig_type());
        }
        if (s_config.isset_create_time) {
            this.setCreate_time(s_config.getCreate_time());
        }
        if (s_config.isset_remark) {
            this.setRemark(s_config.getRemark());
        }
        if (s_config.isset_data_type) {
            this.setData_type(s_config.getData_type());
        }
        if (s_config.isset_group_id) {
            this.setGroup_id(s_config.getGroup_id());
        }
        if (s_config.isset_form_id) {
            this.setForm_id(s_config.getForm_id());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_config.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_config";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return CONFIG_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getConfig_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(CONFIG_ID, this.getConfig_id());
        ib.set(CONFIG_NAME, this.getConfig_name(), this.isset_config_name);
        ib.set(CONFIG_KEY, this.getConfig_key(), this.isset_config_key);
        ib.set(CONFIG_VALUE, this.getConfig_value(), this.isset_config_value);
        ib.set(CONFIG_TYPE, this.getConfig_type(), this.isset_config_type);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(REMARK, this.getRemark(), this.isset_remark);
        ib.set(DATA_TYPE, this.getData_type(), this.isset_data_type);
        ib.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ib.set(FORM_ID, this.getForm_id(), this.isset_form_id);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CONFIG_NAME, this.getConfig_name(), this.isset_config_name);
        ub.set(CONFIG_KEY, this.getConfig_key(), this.isset_config_key);
        ub.set(CONFIG_VALUE, this.getConfig_value(), this.isset_config_value);
        ub.set(CONFIG_TYPE, this.getConfig_type(), this.isset_config_type);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(DATA_TYPE, this.getData_type(), this.isset_data_type);
        ub.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ub.set(FORM_ID, this.getForm_id(), this.isset_form_id);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CONFIG_NAME, this.getConfig_name(), this.isset_config_name);
        ub.set(CONFIG_KEY, this.getConfig_key(), this.isset_config_key);
        ub.set(CONFIG_VALUE, this.getConfig_value(), this.isset_config_value);
        ub.set(CONFIG_TYPE, this.getConfig_type(), this.isset_config_type);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(DATA_TYPE, this.getData_type(), this.isset_data_type);
        ub.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ub.set(FORM_ID, this.getForm_id(), this.isset_form_id);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CONFIG_NAME, this.getConfig_name(), this.isset_config_name);
        ub.set(CONFIG_KEY, this.getConfig_key(), this.isset_config_key);
        ub.set(CONFIG_VALUE, this.getConfig_value(), this.isset_config_value);
        ub.set(CONFIG_TYPE, this.getConfig_type(), this.isset_config_type);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(DATA_TYPE, this.getData_type(), this.isset_data_type);
        ub.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ub.set(FORM_ID, this.getForm_id(), this.isset_form_id);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select config_id, config_name, config_key, config_value, config_type, create_time, remark, data_type, group_id, form_id from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select config_id, config_name, config_key, config_value, config_type, create_time, remark, data_type, group_id, form_id from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_config mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_config toS_config() {
        return super.$clone();
    }
}

/**
 * s_config RowMapper
 *
 * @author genrator
 */
class S_configRowMapper implements RowMapper<S_config> {

    @Override
    public S_config mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_config s_config = new S_config();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.CONFIG_ID);
        if (columnIndex > 0) {
            s_config.setConfig_id(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.CONFIG_NAME);
        if (columnIndex > 0) {
            s_config.setConfig_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.CONFIG_KEY);
        if (columnIndex > 0) {
            s_config.setConfig_key(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.CONFIG_VALUE);
        if (columnIndex > 0) {
            s_config.setConfig_value(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.CONFIG_TYPE);
        if (columnIndex > 0) {
            s_config.setConfig_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_config.setCreate_time(null);
            } else {
                s_config.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.REMARK);
        if (columnIndex > 0) {
            s_config.setRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.DATA_TYPE);
        if (columnIndex > 0) {
            s_config.setData_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.GROUP_ID);
        if (columnIndex > 0) {
            s_config.setGroup_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_mapper.FORM_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_config.setForm_id(null);
            } else {
                s_config.setForm_id(rs.getInt(columnIndex));
            }
        }
        return s_config;
    }
}
