

package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:S_DEPT *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class S_dept extends BasePo<S_dept> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final S_dept ROW_MAPPER = new S_dept();

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long parent_id = null;
    @JsonIgnore
    protected boolean isset_parent_id = false;

    private Long org_id = null;
    @JsonIgnore
    protected boolean isset_org_id = false;

    private String ancestors = null;
    @JsonIgnore
    protected boolean isset_ancestors = false;

    private String dept_name = null;
    @JsonIgnore
    protected boolean isset_dept_name = false;

    private Integer order_num = null;
    @JsonIgnore
    protected boolean isset_order_num = false;

    private String leader = null;
    @JsonIgnore
    protected boolean isset_leader = false;

    private String phone = null;
    @JsonIgnore
    protected boolean isset_phone = false;

    private String email = null;
    @JsonIgnore
    protected boolean isset_email = false;

    private Integer status = null;
    @JsonIgnore
    protected boolean isset_status = false;

    private Integer del_flag = null;
    @JsonIgnore
    protected boolean isset_del_flag = false;

    private String create_by = null;
    @JsonIgnore
    protected boolean isset_create_by = false;

    private Long create_time = null;
    @JsonIgnore
    protected boolean isset_create_time = false;

    private String attribute = null;
    @JsonIgnore
    protected boolean isset_attribute = false;

    private Integer org_type = null;
    @JsonIgnore
    protected boolean isset_org_type = false;

    private String charge_man = null;
    @JsonIgnore
    protected boolean isset_charge_man = false;

    private Integer menu_type = null;
    @JsonIgnore
    protected boolean isset_menu_type = false;

    /**
     * 默认构造函数
     */
    public S_dept() {
    }

    /**
     * 根据主键构造对象
     */
    public S_dept(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

            public Long getId() {
        return this.id;
    }
    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }
    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }


    public Long getParent_id() {
        return this.parent_id;
    }
    public void setParent_id(Long parent_id) {
        this.parent_id = parent_id;
        this.isset_parent_id = true;
        // parent_id, bigint
    }
    @JsonIgnore
    public boolean isEmptyParent_id() {
        return this.parent_id == null;
    }


    public Long getOrg_id() {
        return this.org_id;
    }
    public void setOrg_id(Long org_id) {
        this.org_id = org_id;
        this.isset_org_id = true;
        // org_id, bigint
    }
    @JsonIgnore
    public boolean isEmptyOrg_id() {
        return this.org_id == null;
    }


    public String getAncestors() {
        return this.ancestors;
    }
    public void setAncestors(String ancestors) {
        this.ancestors = ancestors;
        this.isset_ancestors = true;
        // ancestors, varchar
    }
    @JsonIgnore
    public boolean isEmptyAncestors() {
        return this.ancestors == null || this.ancestors.length() == 0;
    }


    public String getDept_name() {
        return this.dept_name;
    }
    public void setDept_name(String dept_name) {
        this.dept_name = dept_name;
        this.isset_dept_name = true;
        // dept_name, varchar
    }
    @JsonIgnore
    public boolean isEmptyDept_name() {
        return this.dept_name == null || this.dept_name.length() == 0;
    }


    public Integer getOrder_num() {
        return this.order_num;
    }
    public void setOrder_num(Integer order_num) {
        this.order_num = order_num;
        this.isset_order_num = true;
        // order_num, int
    }
    @JsonIgnore
    public boolean isEmptyOrder_num() {
        return this.order_num == null;
    }


    public String getLeader() {
        return this.leader;
    }
    public void setLeader(String leader) {
        this.leader = leader;
        this.isset_leader = true;
        // leader, varchar
    }
    @JsonIgnore
    public boolean isEmptyLeader() {
        return this.leader == null || this.leader.length() == 0;
    }


    public String getPhone() {
        return this.phone;
    }
    public void setPhone(String phone) {
        this.phone = phone;
        this.isset_phone = true;
        // phone, varchar
    }
    @JsonIgnore
    public boolean isEmptyPhone() {
        return this.phone == null || this.phone.length() == 0;
    }


    public String getEmail() {
        return this.email;
    }
    public void setEmail(String email) {
        this.email = email;
        this.isset_email = true;
        // email, varchar
    }
    @JsonIgnore
    public boolean isEmptyEmail() {
        return this.email == null || this.email.length() == 0;
    }


    public Integer getStatus() {
        return this.status;
    }
    public void setStatus(Integer status) {
        this.status = status;
        this.isset_status = true;
        // status, int
    }
    @JsonIgnore
    public boolean isEmptyStatus() {
        return this.status == null;
    }


    public Integer getDel_flag() {
        return this.del_flag;
    }
    public void setDel_flag(Integer del_flag) {
        this.del_flag = del_flag;
        this.isset_del_flag = true;
        // del_flag, int
    }
    @JsonIgnore
    public boolean isEmptyDel_flag() {
        return this.del_flag == null;
    }


    public String getCreate_by() {
        return this.create_by;
    }
    public void setCreate_by(String create_by) {
        this.create_by = create_by;
        this.isset_create_by = true;
        // create_by, varchar
    }
    @JsonIgnore
    public boolean isEmptyCreate_by() {
        return this.create_by == null || this.create_by.length() == 0;
    }


    public Long getCreate_time() {
        return this.create_time;
    }
    public void setCreate_time(Long create_time) {
        this.create_time = create_time;
        this.isset_create_time = true;
        // create_time, bigint
    }
    @JsonIgnore
    public boolean isEmptyCreate_time() {
        return this.create_time == null;
    }


    public String getAttribute() {
        return this.attribute;
    }
    public void setAttribute(String attribute) {
        this.attribute = attribute;
        this.isset_attribute = true;
        // attribute, varchar
    }
    @JsonIgnore
    public boolean isEmptyAttribute() {
        return this.attribute == null || this.attribute.length() == 0;
    }


    public Integer getOrg_type() {
        return this.org_type;
    }
    public void setOrg_type(Integer org_type) {
        this.org_type = org_type;
        this.isset_org_type = true;
        // org_type, int
    }
    @JsonIgnore
    public boolean isEmptyOrg_type() {
        return this.org_type == null;
    }


    public String getCharge_man() {
        return this.charge_man;
    }
    public void setCharge_man(String charge_man) {
        this.charge_man = charge_man;
        this.isset_charge_man = true;
        // charge_man, varchar
    }
    @JsonIgnore
    public boolean isEmptyCharge_man() {
        return this.charge_man == null || this.charge_man.length() == 0;
    }


    public Integer getMenu_type() {
        return this.menu_type;
    }
    public void setMenu_type(Integer menu_type) {
        this.menu_type = menu_type;
        this.isset_menu_type = true;
        // menu_type, int
    }
    @JsonIgnore
    public boolean isEmptyMenu_type() {
        return this.menu_type == null;
    }


    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("parent_id=").append(this.parent_id)
                .append("org_id=").append(this.org_id)
                .append("ancestors=").append(this.ancestors)
                .append("dept_name=").append(this.dept_name)
                .append("order_num=").append(this.order_num)
                .append("leader=").append(this.leader)
                .append("phone=").append(this.phone)
                .append("email=").append(this.email)
                .append("status=").append(this.status)
                .append("del_flag=").append(this.del_flag)
                .append("create_by=").append(this.create_by)
                .append("create_time=").append(this.create_time)
                .append("attribute=").append(this.attribute)
                .append("org_type=").append(this.org_type)
                .append("charge_man=").append(this.charge_man)
                .append("menu_type=").append(this.menu_type)
                .toString();
    }

    /**
     * 克隆
     */
    public S_dept $clone() {
        S_dept s_dept = new S_dept();

        // 数据库名称
        //s_dept.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            s_dept.setId(this.getId());
        }
        // 普通属性
        if (this.isset_parent_id) {
            s_dept.setParent_id(this.getParent_id());
        }
        if (this.isset_org_id) {
            s_dept.setOrg_id(this.getOrg_id());
        }
        if (this.isset_ancestors) {
            s_dept.setAncestors(this.getAncestors());
        }
        if (this.isset_dept_name) {
            s_dept.setDept_name(this.getDept_name());
        }
        if (this.isset_order_num) {
            s_dept.setOrder_num(this.getOrder_num());
        }
        if (this.isset_leader) {
            s_dept.setLeader(this.getLeader());
        }
        if (this.isset_phone) {
            s_dept.setPhone(this.getPhone());
        }
        if (this.isset_email) {
            s_dept.setEmail(this.getEmail());
        }
        if (this.isset_status) {
            s_dept.setStatus(this.getStatus());
        }
        if (this.isset_del_flag) {
            s_dept.setDel_flag(this.getDel_flag());
        }
        if (this.isset_create_by) {
            s_dept.setCreate_by(this.getCreate_by());
        }
        if (this.isset_create_time) {
            s_dept.setCreate_time(this.getCreate_time());
        }
        if (this.isset_attribute) {
            s_dept.setAttribute(this.getAttribute());
        }
        if (this.isset_org_type) {
            s_dept.setOrg_type(this.getOrg_type());
        }
        if (this.isset_charge_man) {
            s_dept.setCharge_man(this.getCharge_man());
        }
        if (this.isset_menu_type) {
            s_dept.setMenu_type(this.getMenu_type());
        }
        return s_dept;
    }
}
