package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_DIALOG_RUN *
 * @author genrator
 */
public class S_dialog_run_mapper extends S_dialog_run implements BaseMapper<S_dialog_run> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_dialog_run> ROW_MAPPER = new S_dialog_runRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String CREATE_TIME = "create_time";
    public static final String USER_ID = "user_id";
    public static final String CUSTOMER_SERVICE = "customer_service";
    public static final String START_TIME = "start_time";
    public static final String DATA = "data";
    public static final String UUID = "uuid";
    public static final String DIALOG_ID = "dialog_id";

    /**
     * 默认构造函数
     */
    public S_dialog_run_mapper(S_dialog_run s_dialog_run) {
        if (s_dialog_run == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_dialog_run.isset_id) {
            this.setId(s_dialog_run.getId());
        }
        //普通属性
        if (s_dialog_run.isset_create_time) {
            this.setCreate_time(s_dialog_run.getCreate_time());
        }
        if (s_dialog_run.isset_user_id) {
            this.setUser_id(s_dialog_run.getUser_id());
        }
        if (s_dialog_run.isset_customer_service) {
            this.setCustomer_service(s_dialog_run.getCustomer_service());
        }
        if (s_dialog_run.isset_start_time) {
            this.setStart_time(s_dialog_run.getStart_time());
        }
        if (s_dialog_run.isset_data) {
            this.setData(s_dialog_run.getData());
        }
        if (s_dialog_run.isset_uuid) {
            this.setUuid(s_dialog_run.getUuid());
        }
        if (s_dialog_run.isset_dialog_id) {
            this.setDialog_id(s_dialog_run.getDialog_id());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_dialog_run.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_dialog_run";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ib.set(CUSTOMER_SERVICE, this.getCustomer_service(), this.isset_customer_service);
        ib.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ib.set(DATA, this.getData(), this.isset_data);
        ib.set(UUID, this.getUuid(), this.isset_uuid);
        ib.set(DIALOG_ID, this.getDialog_id(), this.isset_dialog_id);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ub.set(CUSTOMER_SERVICE, this.getCustomer_service(), this.isset_customer_service);
        ub.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ub.set(DATA, this.getData(), this.isset_data);
        ub.set(UUID, this.getUuid(), this.isset_uuid);
        ub.set(DIALOG_ID, this.getDialog_id(), this.isset_dialog_id);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ub.set(CUSTOMER_SERVICE, this.getCustomer_service(), this.isset_customer_service);
        ub.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ub.set(DATA, this.getData(), this.isset_data);
        ub.set(UUID, this.getUuid(), this.isset_uuid);
        ub.set(DIALOG_ID, this.getDialog_id(), this.isset_dialog_id);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(USER_ID, this.getUser_id(), this.isset_user_id);
        ub.set(CUSTOMER_SERVICE, this.getCustomer_service(), this.isset_customer_service);
        ub.set(START_TIME, this.getStart_time(), this.isset_start_time);
        ub.set(DATA, this.getData(), this.isset_data);
        ub.set(UUID, this.getUuid(), this.isset_uuid);
        ub.set(DIALOG_ID, this.getDialog_id(), this.isset_dialog_id);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, user_id, customer_service, start_time, data, uuid, dialog_id from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, user_id, customer_service, start_time, data, uuid, dialog_id from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_dialog_run mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_dialog_run toS_dialog_run() {
        return super.$clone();
    }
}

/**
 * s_dialog_run RowMapper
 *
 * @author genrator
 */
class S_dialog_runRowMapper implements RowMapper<S_dialog_run> {

    @Override
    public S_dialog_run mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_dialog_run s_dialog_run = new S_dialog_run();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.ID);
        if (columnIndex > 0) {
            s_dialog_run.setId(rs.getString(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dialog_run.setCreate_time(null);
            } else {
                s_dialog_run.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.USER_ID);
        if (columnIndex > 0) {
            s_dialog_run.setUser_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.CUSTOMER_SERVICE);
        if (columnIndex > 0) {
            s_dialog_run.setCustomer_service(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.START_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dialog_run.setStart_time(null);
            } else {
                s_dialog_run.setStart_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.DATA);
        if (columnIndex > 0) {
            s_dialog_run.setData(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.UUID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dialog_run.setUuid(null);
            } else {
                s_dialog_run.setUuid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dialog_run_mapper.DIALOG_ID);
        if (columnIndex > 0) {
            s_dialog_run.setDialog_id(rs.getString(columnIndex));
        }
        return s_dialog_run;
    }
}
