package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_DICT_DATA *
 * @author genrator
 */
public class S_dict_data_mapper extends S_dict_data implements BaseMapper<S_dict_data> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_dict_data> ROW_MAPPER = new S_dict_dataRowMapper();

    // 主键
    public static final String DICT_CODE = "dict_code";
    // 普通属性
    public static final String PARENT_ID = "parent_id";
    public static final String DICT_SORT = "dict_sort";
    public static final String DICT_LABEL = "dict_label";
    public static final String DICT_VALUE = "dict_value";
    public static final String DICT_TYPE = "dict_type";
    public static final String CSS_CLASS = "css_class";
    public static final String LIST_CLASS = "list_class";
    public static final String IS_DEFAULT = "is_default";
    public static final String STATUS = "status";
    public static final String CREATE_BY = "create_by";
    public static final String CREATE_TIME = "create_time";
    public static final String REMARK = "remark";

    /**
     * 默认构造函数
     */
    public S_dict_data_mapper(S_dict_data s_dict_data) {
        if (s_dict_data == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_dict_data.isset_dict_code) {
            this.setDict_code(s_dict_data.getDict_code());
        }
        //普通属性
        if (s_dict_data.isset_parent_id) {
            this.setParent_id(s_dict_data.getParent_id());
        }
        if (s_dict_data.isset_dict_sort) {
            this.setDict_sort(s_dict_data.getDict_sort());
        }
        if (s_dict_data.isset_dict_label) {
            this.setDict_label(s_dict_data.getDict_label());
        }
        if (s_dict_data.isset_dict_value) {
            this.setDict_value(s_dict_data.getDict_value());
        }
        if (s_dict_data.isset_dict_type) {
            this.setDict_type(s_dict_data.getDict_type());
        }
        if (s_dict_data.isset_css_class) {
            this.setCss_class(s_dict_data.getCss_class());
        }
        if (s_dict_data.isset_list_class) {
            this.setList_class(s_dict_data.getList_class());
        }
        if (s_dict_data.isset_is_default) {
            this.setIs_default(s_dict_data.getIs_default());
        }
        if (s_dict_data.isset_status) {
            this.setStatus(s_dict_data.getStatus());
        }
        if (s_dict_data.isset_create_by) {
            this.setCreate_by(s_dict_data.getCreate_by());
        }
        if (s_dict_data.isset_create_time) {
            this.setCreate_time(s_dict_data.getCreate_time());
        }
        if (s_dict_data.isset_remark) {
            this.setRemark(s_dict_data.getRemark());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_dict_data.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_dict_data";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return DICT_CODE;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getDict_code();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(DICT_CODE, this.getDict_code());
        ib.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ib.set(DICT_SORT, this.getDict_sort(), this.isset_dict_sort);
        ib.set(DICT_LABEL, this.getDict_label(), this.isset_dict_label);
        ib.set(DICT_VALUE, this.getDict_value(), this.isset_dict_value);
        ib.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ib.set(CSS_CLASS, this.getCss_class(), this.isset_css_class);
        ib.set(LIST_CLASS, this.getList_class(), this.isset_list_class);
        ib.set(IS_DEFAULT, this.getIs_default(), this.isset_is_default);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(REMARK, this.getRemark(), this.isset_remark);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(DICT_SORT, this.getDict_sort(), this.isset_dict_sort);
        ub.set(DICT_LABEL, this.getDict_label(), this.isset_dict_label);
        ub.set(DICT_VALUE, this.getDict_value(), this.isset_dict_value);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(CSS_CLASS, this.getCss_class(), this.isset_css_class);
        ub.set(LIST_CLASS, this.getList_class(), this.isset_list_class);
        ub.set(IS_DEFAULT, this.getIs_default(), this.isset_is_default);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(DICT_SORT, this.getDict_sort(), this.isset_dict_sort);
        ub.set(DICT_LABEL, this.getDict_label(), this.isset_dict_label);
        ub.set(DICT_VALUE, this.getDict_value(), this.isset_dict_value);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(CSS_CLASS, this.getCss_class(), this.isset_css_class);
        ub.set(LIST_CLASS, this.getList_class(), this.isset_list_class);
        ub.set(IS_DEFAULT, this.getIs_default(), this.isset_is_default);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(DICT_SORT, this.getDict_sort(), this.isset_dict_sort);
        ub.set(DICT_LABEL, this.getDict_label(), this.isset_dict_label);
        ub.set(DICT_VALUE, this.getDict_value(), this.isset_dict_value);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(CSS_CLASS, this.getCss_class(), this.isset_css_class);
        ub.set(LIST_CLASS, this.getList_class(), this.isset_list_class);
        ub.set(IS_DEFAULT, this.getIs_default(), this.isset_is_default);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select dict_code, parent_id, dict_sort, dict_label, dict_value, dict_type, css_class, list_class, is_default, status, create_by, create_time, remark from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select dict_code, parent_id, dict_sort, dict_label, dict_value, dict_type, css_class, list_class, is_default, status, create_by, create_time, remark from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_dict_data mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_dict_data toS_dict_data() {
        return super.$clone();
    }
}

/**
 * s_dict_data RowMapper
 *
 * @author genrator
 */
class S_dict_dataRowMapper implements RowMapper<S_dict_data> {

    @Override
    public S_dict_data mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_dict_data s_dict_data = new S_dict_data();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.DICT_CODE);
        if (columnIndex > 0) {
            s_dict_data.setDict_code(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.PARENT_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dict_data.setParent_id(null);
            } else {
                s_dict_data.setParent_id(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.DICT_SORT);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dict_data.setDict_sort(null);
            } else {
                s_dict_data.setDict_sort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.DICT_LABEL);
        if (columnIndex > 0) {
            s_dict_data.setDict_label(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.DICT_VALUE);
        if (columnIndex > 0) {
            s_dict_data.setDict_value(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.DICT_TYPE);
        if (columnIndex > 0) {
            s_dict_data.setDict_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.CSS_CLASS);
        if (columnIndex > 0) {
            s_dict_data.setCss_class(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.LIST_CLASS);
        if (columnIndex > 0) {
            s_dict_data.setList_class(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.IS_DEFAULT);
        if (columnIndex > 0) {
            s_dict_data.setIs_default(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dict_data.setStatus(null);
            } else {
                s_dict_data.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.CREATE_BY);
        if (columnIndex > 0) {
            s_dict_data.setCreate_by(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dict_data.setCreate_time(null);
            } else {
                s_dict_data.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_data_mapper.REMARK);
        if (columnIndex > 0) {
            s_dict_data.setRemark(rs.getString(columnIndex));
        }
        return s_dict_data;
    }
}
