

package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:S_GROUP *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class S_group extends BasePo<S_group> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final S_group ROW_MAPPER = new S_group();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private String info = null;
    @JsonIgnore
    protected boolean isset_info = false;

    private Integer form_id = null;
    @JsonIgnore
    protected boolean isset_form_id = false;

    private Long create_time = null;
    @JsonIgnore
    protected boolean isset_create_time = false;

    private Long update_time = null;
    @JsonIgnore
    protected boolean isset_update_time = false;

    /**
     * 默认构造函数
     */
    public S_group() {
    }

    /**
     * 根据主键构造对象
     */
    public S_group(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

            public Integer getId() {
        return this.id;
    }
    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }
    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }


    public String getName() {
        return this.name;
    }
    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
        // name, varchar
    }
    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }


    public String getInfo() {
        return this.info;
    }
    public void setInfo(String info) {
        this.info = info;
        this.isset_info = true;
        // info, varchar
    }
    @JsonIgnore
    public boolean isEmptyInfo() {
        return this.info == null || this.info.length() == 0;
    }


    public Integer getForm_id() {
        return this.form_id;
    }
    public void setForm_id(Integer form_id) {
        this.form_id = form_id;
        this.isset_form_id = true;
        // form_id, int
    }
    @JsonIgnore
    public boolean isEmptyForm_id() {
        return this.form_id == null;
    }


    public Long getCreate_time() {
        return this.create_time;
    }
    public void setCreate_time(Long create_time) {
        this.create_time = create_time;
        this.isset_create_time = true;
        // create_time, bigint
    }
    @JsonIgnore
    public boolean isEmptyCreate_time() {
        return this.create_time == null;
    }


    public Long getUpdate_time() {
        return this.update_time;
    }
    public void setUpdate_time(Long update_time) {
        this.update_time = update_time;
        this.isset_update_time = true;
        // update_time, bigint
    }
    @JsonIgnore
    public boolean isEmptyUpdate_time() {
        return this.update_time == null;
    }


    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("name=").append(this.name)
                .append("info=").append(this.info)
                .append("form_id=").append(this.form_id)
                .append("create_time=").append(this.create_time)
                .append("update_time=").append(this.update_time)
                .toString();
    }

    /**
     * 克隆
     */
    public S_group $clone() {
        S_group s_group = new S_group();

        // 数据库名称
        //s_group.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            s_group.setId(this.getId());
        }
        // 普通属性
        if (this.isset_name) {
            s_group.setName(this.getName());
        }
        if (this.isset_info) {
            s_group.setInfo(this.getInfo());
        }
        if (this.isset_form_id) {
            s_group.setForm_id(this.getForm_id());
        }
        if (this.isset_create_time) {
            s_group.setCreate_time(this.getCreate_time());
        }
        if (this.isset_update_time) {
            s_group.setUpdate_time(this.getUpdate_time());
        }
        return s_group;
    }
}
