package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_GROUP_DATA *
 * @author genrator
 */
public class S_group_data_mapper extends S_group_data implements BaseMapper<S_group_data> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_group_data> ROW_MAPPER = new S_group_dataRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String GID = "gid";
    public static final String VALUE = "value";
    public static final String SORT = "sort";
    public static final String STATUS = "status";
    public static final String CREATE_TIME = "create_time";
    public static final String UPDATE_TIME = "update_time";

    /**
     * 默认构造函数
     */
    public S_group_data_mapper(S_group_data s_group_data) {
        if (s_group_data == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_group_data.isset_id) {
            this.setId(s_group_data.getId());
        }
        //普通属性
        if (s_group_data.isset_gid) {
            this.setGid(s_group_data.getGid());
        }
        if (s_group_data.isset_value) {
            this.setValue(s_group_data.getValue());
        }
        if (s_group_data.isset_sort) {
            this.setSort(s_group_data.getSort());
        }
        if (s_group_data.isset_status) {
            this.setStatus(s_group_data.getStatus());
        }
        if (s_group_data.isset_create_time) {
            this.setCreate_time(s_group_data.getCreate_time());
        }
        if (s_group_data.isset_update_time) {
            this.setUpdate_time(s_group_data.getUpdate_time());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_group_data.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_group_data";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(GID, this.getGid(), this.isset_gid);
        ib.set(VALUE, this.getValue(), this.isset_value);
        ib.set(SORT, this.getSort(), this.isset_sort);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(GID, this.getGid(), this.isset_gid);
        ub.set(VALUE, this.getValue(), this.isset_value);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(GID, this.getGid(), this.isset_gid);
        ub.set(VALUE, this.getValue(), this.isset_value);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(GID, this.getGid(), this.isset_gid);
        ub.set(VALUE, this.getValue(), this.isset_value);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, gid, value, sort, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, gid, value, sort, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_group_data mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_group_data toS_group_data() {
        return super.$clone();
    }
}

/**
 * s_group_data RowMapper
 *
 * @author genrator
 */
class S_group_dataRowMapper implements RowMapper<S_group_data> {

    @Override
    public S_group_data mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_group_data s_group_data = new S_group_data();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_group_data_mapper.ID);
        if (columnIndex > 0) {
            s_group_data.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_group_data_mapper.GID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group_data.setGid(null);
            } else {
                s_group_data.setGid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_data_mapper.VALUE);
        if (columnIndex > 0) {
            s_group_data.setValue(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_data_mapper.SORT);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group_data.setSort(null);
            } else {
                s_group_data.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_data_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group_data.setStatus(null);
            } else {
                s_group_data.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_data_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group_data.setCreate_time(null);
            } else {
                s_group_data.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_data_mapper.UPDATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group_data.setUpdate_time(null);
            } else {
                s_group_data.setUpdate_time(rs.getLong(columnIndex));
            }
        }
        return s_group_data;
    }
}
