package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_GROUP *
 * @author genrator
 */
public class S_group_mapper extends S_group implements BaseMapper<S_group> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_group> ROW_MAPPER = new S_groupRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String NAME = "name";
    public static final String INFO = "info";
    public static final String FORM_ID = "form_id";
    public static final String CREATE_TIME = "create_time";
    public static final String UPDATE_TIME = "update_time";

    /**
     * 默认构造函数
     */
    public S_group_mapper(S_group s_group) {
        if (s_group == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_group.isset_id) {
            this.setId(s_group.getId());
        }
        //普通属性
        if (s_group.isset_name) {
            this.setName(s_group.getName());
        }
        if (s_group.isset_info) {
            this.setInfo(s_group.getInfo());
        }
        if (s_group.isset_form_id) {
            this.setForm_id(s_group.getForm_id());
        }
        if (s_group.isset_create_time) {
            this.setCreate_time(s_group.getCreate_time());
        }
        if (s_group.isset_update_time) {
            this.setUpdate_time(s_group.getUpdate_time());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_group.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_group";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(NAME, this.getName(), this.isset_name);
        ib.set(INFO, this.getInfo(), this.isset_info);
        ib.set(FORM_ID, this.getForm_id(), this.isset_form_id);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(INFO, this.getInfo(), this.isset_info);
        ub.set(FORM_ID, this.getForm_id(), this.isset_form_id);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(INFO, this.getInfo(), this.isset_info);
        ub.set(FORM_ID, this.getForm_id(), this.isset_form_id);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(INFO, this.getInfo(), this.isset_info);
        ub.set(FORM_ID, this.getForm_id(), this.isset_form_id);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, name, info, form_id, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, name, info, form_id, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_group mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_group toS_group() {
        return super.$clone();
    }
}

/**
 * s_group RowMapper
 *
 * @author genrator
 */
class S_groupRowMapper implements RowMapper<S_group> {

    @Override
    public S_group mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_group s_group = new S_group();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_group_mapper.ID);
        if (columnIndex > 0) {
            s_group.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_group_mapper.NAME);
        if (columnIndex > 0) {
            s_group.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_mapper.INFO);
        if (columnIndex > 0) {
            s_group.setInfo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_mapper.FORM_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group.setForm_id(null);
            } else {
                s_group.setForm_id(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group.setCreate_time(null);
            } else {
                s_group.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_group_mapper.UPDATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_group.setUpdate_time(null);
            } else {
                s_group.setUpdate_time(rs.getLong(columnIndex));
            }
        }
        return s_group;
    }
}
