package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:S_HOST *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class S_host extends BasePo<S_host> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final S_host ROW_MAPPER = new S_host();

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long create_time = null;
    @JsonIgnore
    protected boolean isset_create_time = false;

    private String create_user = null;
    @JsonIgnore
    protected boolean isset_create_user = false;

    private String url = null;
    @JsonIgnore
    protected boolean isset_url = false;

    private Integer port = null;
    @JsonIgnore
    protected boolean isset_port = false;

    private String service_name = null;
    @JsonIgnore
    protected boolean isset_service_name = false;

    private String authentication = null;
    @JsonIgnore
    protected boolean isset_authentication = false;

    private String certification = null;
    @JsonIgnore
    protected boolean isset_certification = false;

    private Integer max_active = null;
    @JsonIgnore
    protected boolean isset_max_active = false;

    /**
     * 默认构造函数
     */
    public S_host() {
    }

    /**
     * 根据主键构造对象
     */
    public S_host(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getCreate_time() {
        return this.create_time;
    }

    public void setCreate_time(Long create_time) {
        this.create_time = create_time;
        this.isset_create_time = true;
    }

    @JsonIgnore
    public boolean isEmptyCreate_time() {
        return this.create_time == null;
    }

    public String getCreate_user() {
        return this.create_user;
    }

    public void setCreate_user(String create_user) {
        this.create_user = create_user;
        this.isset_create_user = true;
    }

    @JsonIgnore
    public boolean isEmptyCreate_user() {
        return this.create_user == null || this.create_user.length() == 0;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.isset_url = true;
    }

    @JsonIgnore
    public boolean isEmptyUrl() {
        return this.url == null || this.url.length() == 0;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
        this.isset_port = true;
    }

    @JsonIgnore
    public boolean isEmptyPort() {
        return this.port == null;
    }

    public String getService_name() {
        return this.service_name;
    }

    public void setService_name(String service_name) {
        this.service_name = service_name;
        this.isset_service_name = true;
    }

    @JsonIgnore
    public boolean isEmptyService_name() {
        return this.service_name == null || this.service_name.length() == 0;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
        this.isset_authentication = true;
    }

    @JsonIgnore
    public boolean isEmptyAuthentication() {
        return this.authentication == null || this.authentication.length() == 0;
    }

    public String getCertification() {
        return this.certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
        this.isset_certification = true;
    }

    @JsonIgnore
    public boolean isEmptyCertification() {
        return this.certification == null || this.certification.length() == 0;
    }

    public Integer getMax_active() {
        return this.max_active;
    }

    public void setMax_active(Integer max_active) {
        this.max_active = max_active;
        this.isset_max_active = true;
    }

    @JsonIgnore
    public boolean isEmptyMax_active() {
        return this.max_active == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("create_time=").append(this.create_time)
                .append("create_user=").append(this.create_user)
                .append("url=").append(this.url)
                .append("port=").append(this.port)
                .append("service_name=").append(this.service_name)
                .append("authentication=").append(this.authentication)
                .append("certification=").append(this.certification)
                .append("max_active=").append(this.max_active)
                .toString();
    }

    /**
     * 克隆
     */
    public S_host $clone() {
        S_host s_host = new S_host();

        // 数据库名称
        //s_host.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            s_host.setId(this.getId());
        }
        // 普通属性
        if (this.isset_create_time) {
            s_host.setCreate_time(this.getCreate_time());
        }
        if (this.isset_create_user) {
            s_host.setCreate_user(this.getCreate_user());
        }
        if (this.isset_url) {
            s_host.setUrl(this.getUrl());
        }
        if (this.isset_port) {
            s_host.setPort(this.getPort());
        }
        if (this.isset_service_name) {
            s_host.setService_name(this.getService_name());
        }
        if (this.isset_authentication) {
            s_host.setAuthentication(this.getAuthentication());
        }
        if (this.isset_certification) {
            s_host.setCertification(this.getCertification());
        }
        if (this.isset_max_active) {
            s_host.setMax_active(this.getMax_active());
        }
        return s_host;
    }
}
