package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_MESSAGE *
 * @author genrator
 */
public class S_message_mapper extends S_message implements BaseMapper<S_message> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_message> ROW_MAPPER = new S_messageRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String CREATE_TIME = "create_time";
    public static final String CREATOR = "creator";
    public static final String MSG_FROM = "msg_from";
    public static final String RECEIVER = "receiver";
    public static final String CHANNEL_INDEX = "channel_index";
    public static final String TIME_TYPE = "time_type";
    public static final String DELAYED_TIME = "delayed_time";
    public static final String TITLE = "title";
    public static final String CONTENT = "content";
    public static final String BROAD_CAST = "broad_cast";
    public static final String OPTION_TYPE = "option_type";
    public static final String OPTION_ID = "option_id";
    public static final String READ_DONE = "read_done";
    public static final String READ_TIME = "read_time";
    public static final String FAILED = "failed";
    public static final String SUMMARY = "summary";

    /**
     * 默认构造函数
     */
    public S_message_mapper(S_message s_message) {
        if (s_message == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_message.isset_id) {
            this.setId(s_message.getId());
        }
        //普通属性
        if (s_message.isset_create_time) {
            this.setCreate_time(s_message.getCreate_time());
        }
        if (s_message.isset_creator) {
            this.setCreator(s_message.getCreator());
        }
        if (s_message.isset_msg_from) {
            this.setMsg_from(s_message.getMsg_from());
        }
        if (s_message.isset_receiver) {
            this.setReceiver(s_message.getReceiver());
        }
        if (s_message.isset_channel_index) {
            this.setChannel_index(s_message.getChannel_index());
        }
        if (s_message.isset_time_type) {
            this.setTime_type(s_message.getTime_type());
        }
        if (s_message.isset_delayed_time) {
            this.setDelayed_time(s_message.getDelayed_time());
        }
        if (s_message.isset_title) {
            this.setTitle(s_message.getTitle());
        }
        if (s_message.isset_content) {
            this.setContent(s_message.getContent());
        }
        if (s_message.isset_broad_cast) {
            this.setBroad_cast(s_message.getBroad_cast());
        }
        if (s_message.isset_option_type) {
            this.setOption_type(s_message.getOption_type());
        }
        if (s_message.isset_option_id) {
            this.setOption_id(s_message.getOption_id());
        }
        if (s_message.isset_read_done) {
            this.setRead_done(s_message.getRead_done());
        }
        if (s_message.isset_read_time) {
            this.setRead_time(s_message.getRead_time());
        }
        if (s_message.isset_failed) {
            this.setFailed(s_message.getFailed());
        }
        if (s_message.isset_summary) {
            this.setSummary(s_message.getSummary());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_message.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_message";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(CREATOR, this.getCreator(), this.isset_creator);
        ib.set(MSG_FROM, this.getMsg_from(), this.isset_msg_from);
        ib.set(RECEIVER, this.getReceiver(), this.isset_receiver);
        ib.set(CHANNEL_INDEX, this.getChannel_index(), this.isset_channel_index);
        ib.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ib.set(DELAYED_TIME, this.getDelayed_time(), this.isset_delayed_time);
        ib.set(TITLE, this.getTitle(), this.isset_title);
        ib.set(CONTENT, this.getContent(), this.isset_content);
        ib.set(BROAD_CAST, this.getBroad_cast(), this.isset_broad_cast);
        ib.set(OPTION_TYPE, this.getOption_type(), this.isset_option_type);
        ib.set(OPTION_ID, this.getOption_id(), this.isset_option_id);
        ib.set(READ_DONE, this.getRead_done(), this.isset_read_done);
        ib.set(READ_TIME, this.getRead_time(), this.isset_read_time);
        ib.set(FAILED, this.getFailed(), this.isset_failed);
        ib.set(SUMMARY, this.getSummary(), this.isset_summary);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CREATOR, this.getCreator(), this.isset_creator);
        ub.set(MSG_FROM, this.getMsg_from(), this.isset_msg_from);
        ub.set(RECEIVER, this.getReceiver(), this.isset_receiver);
        ub.set(CHANNEL_INDEX, this.getChannel_index(), this.isset_channel_index);
        ub.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ub.set(DELAYED_TIME, this.getDelayed_time(), this.isset_delayed_time);
        ub.set(TITLE, this.getTitle(), this.isset_title);
        ub.set(CONTENT, this.getContent(), this.isset_content);
        ub.set(BROAD_CAST, this.getBroad_cast(), this.isset_broad_cast);
        ub.set(OPTION_TYPE, this.getOption_type(), this.isset_option_type);
        ub.set(OPTION_ID, this.getOption_id(), this.isset_option_id);
        ub.set(READ_DONE, this.getRead_done(), this.isset_read_done);
        ub.set(READ_TIME, this.getRead_time(), this.isset_read_time);
        ub.set(FAILED, this.getFailed(), this.isset_failed);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CREATOR, this.getCreator(), this.isset_creator);
        ub.set(MSG_FROM, this.getMsg_from(), this.isset_msg_from);
        ub.set(RECEIVER, this.getReceiver(), this.isset_receiver);
        ub.set(CHANNEL_INDEX, this.getChannel_index(), this.isset_channel_index);
        ub.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ub.set(DELAYED_TIME, this.getDelayed_time(), this.isset_delayed_time);
        ub.set(TITLE, this.getTitle(), this.isset_title);
        ub.set(CONTENT, this.getContent(), this.isset_content);
        ub.set(BROAD_CAST, this.getBroad_cast(), this.isset_broad_cast);
        ub.set(OPTION_TYPE, this.getOption_type(), this.isset_option_type);
        ub.set(OPTION_ID, this.getOption_id(), this.isset_option_id);
        ub.set(READ_DONE, this.getRead_done(), this.isset_read_done);
        ub.set(READ_TIME, this.getRead_time(), this.isset_read_time);
        ub.set(FAILED, this.getFailed(), this.isset_failed);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CREATOR, this.getCreator(), this.isset_creator);
        ub.set(MSG_FROM, this.getMsg_from(), this.isset_msg_from);
        ub.set(RECEIVER, this.getReceiver(), this.isset_receiver);
        ub.set(CHANNEL_INDEX, this.getChannel_index(), this.isset_channel_index);
        ub.set(TIME_TYPE, this.getTime_type(), this.isset_time_type);
        ub.set(DELAYED_TIME, this.getDelayed_time(), this.isset_delayed_time);
        ub.set(TITLE, this.getTitle(), this.isset_title);
        ub.set(CONTENT, this.getContent(), this.isset_content);
        ub.set(BROAD_CAST, this.getBroad_cast(), this.isset_broad_cast);
        ub.set(OPTION_TYPE, this.getOption_type(), this.isset_option_type);
        ub.set(OPTION_ID, this.getOption_id(), this.isset_option_id);
        ub.set(READ_DONE, this.getRead_done(), this.isset_read_done);
        ub.set(READ_TIME, this.getRead_time(), this.isset_read_time);
        ub.set(FAILED, this.getFailed(), this.isset_failed);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, creator, msg_from, receiver, channel_index, time_type, delayed_time, title, content, broad_cast, option_type, option_id, read_done, read_time, failed, summary from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, creator, msg_from, receiver, channel_index, time_type, delayed_time, title, content, broad_cast, option_type, option_id, read_done, read_time, failed, summary from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_message mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_message toS_message() {
        return super.$clone();
    }
}

/**
 * s_message RowMapper
 *
 * @author genrator
 */
class S_messageRowMapper implements RowMapper<S_message> {

    @Override
    public S_message mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_message s_message = new S_message();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.ID);
        if (columnIndex > 0) {
            s_message.setId(rs.getString(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_message.setCreate_time(null);
            } else {
                s_message.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.CREATOR);
        if (columnIndex > 0) {
            s_message.setCreator(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.MSG_FROM);
        if (columnIndex > 0) {
            s_message.setMsg_from(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.RECEIVER);
        if (columnIndex > 0) {
            s_message.setReceiver(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.CHANNEL_INDEX);
        if (columnIndex > 0) {
            s_message.setChannel_index(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.TIME_TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_message.setTime_type(null);
            } else {
                s_message.setTime_type(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.DELAYED_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_message.setDelayed_time(null);
            } else {
                s_message.setDelayed_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.TITLE);
        if (columnIndex > 0) {
            s_message.setTitle(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.CONTENT);
        if (columnIndex > 0) {
            s_message.setContent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.BROAD_CAST);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_message.setBroad_cast(null);
            } else {
                s_message.setBroad_cast(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.OPTION_TYPE);
        if (columnIndex > 0) {
            s_message.setOption_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.OPTION_ID);
        if (columnIndex > 0) {
            s_message.setOption_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.READ_DONE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_message.setRead_done(null);
            } else {
                s_message.setRead_done(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.READ_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_message.setRead_time(null);
            } else {
                s_message.setRead_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.FAILED);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_message.setFailed(null);
            } else {
                s_message.setFailed(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_message_mapper.SUMMARY);
        if (columnIndex > 0) {
            s_message.setSummary(rs.getString(columnIndex));
        }
        return s_message;
    }
}
