package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_OPER_LOG *
 * @author genrator
 */
public class S_oper_log_mapper extends S_oper_log implements BaseMapper<S_oper_log> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_oper_log> ROW_MAPPER = new S_oper_logRowMapper();

    // 主键
    public static final String OPER_ID = "oper_id";
    // 普通属性
    public static final String TITLE = "title";
    public static final String BUSINESS_TYPE = "business_type";
    public static final String METHOD = "method";
    public static final String REQUEST_METHOD = "request_method";
    public static final String OPERATE_USER = "operate_user";
    public static final String OPER_NAME = "oper_name";
    public static final String DEPT_NAME = "dept_name";
    public static final String OPER_URL = "oper_url";
    public static final String OPER_IP = "oper_ip";
    public static final String OPER_LOCATION = "oper_location";
    public static final String OPER_PARAM = "oper_param";
    public static final String JSON_RESULT = "json_result";
    public static final String STATUS = "status";
    public static final String ERROR_MSG = "error_msg";
    public static final String OPER_TIME = "oper_time";

    /**
     * 默认构造函数
     */
    public S_oper_log_mapper(S_oper_log s_oper_log) {
        if (s_oper_log == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_oper_log.isset_oper_id) {
            this.setOper_id(s_oper_log.getOper_id());
        }
        //普通属性
        if (s_oper_log.isset_title) {
            this.setTitle(s_oper_log.getTitle());
        }
        if (s_oper_log.isset_business_type) {
            this.setBusiness_type(s_oper_log.getBusiness_type());
        }
        if (s_oper_log.isset_method) {
            this.setMethod(s_oper_log.getMethod());
        }
        if (s_oper_log.isset_request_method) {
            this.setRequest_method(s_oper_log.getRequest_method());
        }
        if (s_oper_log.isset_operate_user) {
            this.setOperate_user(s_oper_log.getOperate_user());
        }
        if (s_oper_log.isset_oper_name) {
            this.setOper_name(s_oper_log.getOper_name());
        }
        if (s_oper_log.isset_dept_name) {
            this.setDept_name(s_oper_log.getDept_name());
        }
        if (s_oper_log.isset_oper_url) {
            this.setOper_url(s_oper_log.getOper_url());
        }
        if (s_oper_log.isset_oper_ip) {
            this.setOper_ip(s_oper_log.getOper_ip());
        }
        if (s_oper_log.isset_oper_location) {
            this.setOper_location(s_oper_log.getOper_location());
        }
        if (s_oper_log.isset_oper_param) {
            this.setOper_param(s_oper_log.getOper_param());
        }
        if (s_oper_log.isset_json_result) {
            this.setJson_result(s_oper_log.getJson_result());
        }
        if (s_oper_log.isset_status) {
            this.setStatus(s_oper_log.getStatus());
        }
        if (s_oper_log.isset_error_msg) {
            this.setError_msg(s_oper_log.getError_msg());
        }
        if (s_oper_log.isset_oper_time) {
            this.setOper_time(s_oper_log.getOper_time());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_oper_log.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_oper_log";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return OPER_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getOper_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(OPER_ID, this.getOper_id());
        ib.set(TITLE, this.getTitle(), this.isset_title);
        ib.set(BUSINESS_TYPE, this.getBusiness_type(), this.isset_business_type);
        ib.set(METHOD, this.getMethod(), this.isset_method);
        ib.set(REQUEST_METHOD, this.getRequest_method(), this.isset_request_method);
        ib.set(OPERATE_USER, this.getOperate_user(), this.isset_operate_user);
        ib.set(OPER_NAME, this.getOper_name(), this.isset_oper_name);
        ib.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ib.set(OPER_URL, this.getOper_url(), this.isset_oper_url);
        ib.set(OPER_IP, this.getOper_ip(), this.isset_oper_ip);
        ib.set(OPER_LOCATION, this.getOper_location(), this.isset_oper_location);
        ib.set(OPER_PARAM, this.getOper_param(), this.isset_oper_param);
        ib.set(JSON_RESULT, this.getJson_result(), this.isset_json_result);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(ERROR_MSG, this.getError_msg(), this.isset_error_msg);
        ib.set(OPER_TIME, this.getOper_time(), this.isset_oper_time);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TITLE, this.getTitle(), this.isset_title);
        ub.set(BUSINESS_TYPE, this.getBusiness_type(), this.isset_business_type);
        ub.set(METHOD, this.getMethod(), this.isset_method);
        ub.set(REQUEST_METHOD, this.getRequest_method(), this.isset_request_method);
        ub.set(OPERATE_USER, this.getOperate_user(), this.isset_operate_user);
        ub.set(OPER_NAME, this.getOper_name(), this.isset_oper_name);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ub.set(OPER_URL, this.getOper_url(), this.isset_oper_url);
        ub.set(OPER_IP, this.getOper_ip(), this.isset_oper_ip);
        ub.set(OPER_LOCATION, this.getOper_location(), this.isset_oper_location);
        ub.set(OPER_PARAM, this.getOper_param(), this.isset_oper_param);
        ub.set(JSON_RESULT, this.getJson_result(), this.isset_json_result);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(ERROR_MSG, this.getError_msg(), this.isset_error_msg);
        ub.set(OPER_TIME, this.getOper_time(), this.isset_oper_time);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TITLE, this.getTitle(), this.isset_title);
        ub.set(BUSINESS_TYPE, this.getBusiness_type(), this.isset_business_type);
        ub.set(METHOD, this.getMethod(), this.isset_method);
        ub.set(REQUEST_METHOD, this.getRequest_method(), this.isset_request_method);
        ub.set(OPERATE_USER, this.getOperate_user(), this.isset_operate_user);
        ub.set(OPER_NAME, this.getOper_name(), this.isset_oper_name);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ub.set(OPER_URL, this.getOper_url(), this.isset_oper_url);
        ub.set(OPER_IP, this.getOper_ip(), this.isset_oper_ip);
        ub.set(OPER_LOCATION, this.getOper_location(), this.isset_oper_location);
        ub.set(OPER_PARAM, this.getOper_param(), this.isset_oper_param);
        ub.set(JSON_RESULT, this.getJson_result(), this.isset_json_result);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(ERROR_MSG, this.getError_msg(), this.isset_error_msg);
        ub.set(OPER_TIME, this.getOper_time(), this.isset_oper_time);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TITLE, this.getTitle(), this.isset_title);
        ub.set(BUSINESS_TYPE, this.getBusiness_type(), this.isset_business_type);
        ub.set(METHOD, this.getMethod(), this.isset_method);
        ub.set(REQUEST_METHOD, this.getRequest_method(), this.isset_request_method);
        ub.set(OPERATE_USER, this.getOperate_user(), this.isset_operate_user);
        ub.set(OPER_NAME, this.getOper_name(), this.isset_oper_name);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ub.set(OPER_URL, this.getOper_url(), this.isset_oper_url);
        ub.set(OPER_IP, this.getOper_ip(), this.isset_oper_ip);
        ub.set(OPER_LOCATION, this.getOper_location(), this.isset_oper_location);
        ub.set(OPER_PARAM, this.getOper_param(), this.isset_oper_param);
        ub.set(JSON_RESULT, this.getJson_result(), this.isset_json_result);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(ERROR_MSG, this.getError_msg(), this.isset_error_msg);
        ub.set(OPER_TIME, this.getOper_time(), this.isset_oper_time);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select oper_id, title, business_type, method, request_method, operate_user, oper_name, dept_name, oper_url, oper_ip, oper_location, oper_param, json_result, status, error_msg, oper_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select oper_id, title, business_type, method, request_method, operate_user, oper_name, dept_name, oper_url, oper_ip, oper_location, oper_param, json_result, status, error_msg, oper_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_oper_log mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_oper_log toS_oper_log() {
        return super.$clone();
    }
}

/**
 * s_oper_log RowMapper
 *
 * @author genrator
 */
class S_oper_logRowMapper implements RowMapper<S_oper_log> {

    @Override
    public S_oper_log mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_oper_log s_oper_log = new S_oper_log();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPER_ID);
        if (columnIndex > 0) {
            s_oper_log.setOper_id(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.TITLE);
        if (columnIndex > 0) {
            s_oper_log.setTitle(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.BUSINESS_TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_oper_log.setBusiness_type(null);
            } else {
                s_oper_log.setBusiness_type(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.METHOD);
        if (columnIndex > 0) {
            s_oper_log.setMethod(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.REQUEST_METHOD);
        if (columnIndex > 0) {
            s_oper_log.setRequest_method(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPERATE_USER);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_oper_log.setOperate_user(null);
            } else {
                s_oper_log.setOperate_user(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPER_NAME);
        if (columnIndex > 0) {
            s_oper_log.setOper_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.DEPT_NAME);
        if (columnIndex > 0) {
            s_oper_log.setDept_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPER_URL);
        if (columnIndex > 0) {
            s_oper_log.setOper_url(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPER_IP);
        if (columnIndex > 0) {
            s_oper_log.setOper_ip(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPER_LOCATION);
        if (columnIndex > 0) {
            s_oper_log.setOper_location(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPER_PARAM);
        if (columnIndex > 0) {
            s_oper_log.setOper_param(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.JSON_RESULT);
        if (columnIndex > 0) {
            s_oper_log.setJson_result(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_oper_log.setStatus(null);
            } else {
                s_oper_log.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.ERROR_MSG);
        if (columnIndex > 0) {
            s_oper_log.setError_msg(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_oper_log_mapper.OPER_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_oper_log.setOper_time(null);
            } else {
                s_oper_log.setOper_time(rs.getLong(columnIndex));
            }
        }
        return s_oper_log;
    }
}
