package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_ROLE *
 * @author genrator
 */
public class S_role_mapper extends S_role implements BaseMapper<S_role> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_role> ROW_MAPPER = new S_roleRowMapper();

    // 主键
    public static final String ROLE_ID = "role_id";
    // 普通属性
    public static final String ROLE_NAME = "role_name";
    public static final String ROLE_KEY = "role_key";
    public static final String ROLE_SORT = "role_sort";
    public static final String DATA_SCOPE = "data_scope";
    public static final String MENU_CHECK_STRICTLY = "menu_check_strictly";
    public static final String DEPT_CHECK_STRICTLY = "dept_check_strictly";
    public static final String STATUS = "status";
    public static final String DEL_FLAG = "del_flag";
    public static final String REMARK = "remark";
    public static final String ORG_ID = "org_id";
    public static final String TYPE = "type";

    /**
     * 默认构造函数
     */
    public S_role_mapper(S_role s_role) {
        if (s_role == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_role.isset_role_id) {
            this.setRole_id(s_role.getRole_id());
        }
        //普通属性
        if (s_role.isset_role_name) {
            this.setRole_name(s_role.getRole_name());
        }
        if (s_role.isset_role_key) {
            this.setRole_key(s_role.getRole_key());
        }
        if (s_role.isset_role_sort) {
            this.setRole_sort(s_role.getRole_sort());
        }
        if (s_role.isset_data_scope) {
            this.setData_scope(s_role.getData_scope());
        }
        if (s_role.isset_menu_check_strictly) {
            this.setMenu_check_strictly(s_role.getMenu_check_strictly());
        }
        if (s_role.isset_dept_check_strictly) {
            this.setDept_check_strictly(s_role.getDept_check_strictly());
        }
        if (s_role.isset_status) {
            this.setStatus(s_role.getStatus());
        }
        if (s_role.isset_del_flag) {
            this.setDel_flag(s_role.getDel_flag());
        }
        if (s_role.isset_remark) {
            this.setRemark(s_role.getRemark());
        }
        if (s_role.isset_org_id) {
            this.setOrg_id(s_role.getOrg_id());
        }
        if (s_role.isset_type) {
            this.setType(s_role.getType());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_role.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_role";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ROLE_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getRole_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ROLE_ID, this.getRole_id());
        ib.set(ROLE_NAME, this.getRole_name(), this.isset_role_name);
        ib.set(ROLE_KEY, this.getRole_key(), this.isset_role_key);
        ib.set(ROLE_SORT, this.getRole_sort(), this.isset_role_sort);
        ib.set(DATA_SCOPE, this.getData_scope(), this.isset_data_scope);
        ib.set(MENU_CHECK_STRICTLY, this.getMenu_check_strictly(), this.isset_menu_check_strictly);
        ib.set(DEPT_CHECK_STRICTLY, this.getDept_check_strictly(), this.isset_dept_check_strictly);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ib.set(REMARK, this.getRemark(), this.isset_remark);
        ib.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ib.set(TYPE, this.getType(), this.isset_type);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ROLE_NAME, this.getRole_name(), this.isset_role_name);
        ub.set(ROLE_KEY, this.getRole_key(), this.isset_role_key);
        ub.set(ROLE_SORT, this.getRole_sort(), this.isset_role_sort);
        ub.set(DATA_SCOPE, this.getData_scope(), this.isset_data_scope);
        ub.set(MENU_CHECK_STRICTLY, this.getMenu_check_strictly(), this.isset_menu_check_strictly);
        ub.set(DEPT_CHECK_STRICTLY, this.getDept_check_strictly(), this.isset_dept_check_strictly);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ROLE_NAME, this.getRole_name(), this.isset_role_name);
        ub.set(ROLE_KEY, this.getRole_key(), this.isset_role_key);
        ub.set(ROLE_SORT, this.getRole_sort(), this.isset_role_sort);
        ub.set(DATA_SCOPE, this.getData_scope(), this.isset_data_scope);
        ub.set(MENU_CHECK_STRICTLY, this.getMenu_check_strictly(), this.isset_menu_check_strictly);
        ub.set(DEPT_CHECK_STRICTLY, this.getDept_check_strictly(), this.isset_dept_check_strictly);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(TYPE, this.getType(), this.isset_type);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ROLE_NAME, this.getRole_name(), this.isset_role_name);
        ub.set(ROLE_KEY, this.getRole_key(), this.isset_role_key);
        ub.set(ROLE_SORT, this.getRole_sort(), this.isset_role_sort);
        ub.set(DATA_SCOPE, this.getData_scope(), this.isset_data_scope);
        ub.set(MENU_CHECK_STRICTLY, this.getMenu_check_strictly(), this.isset_menu_check_strictly);
        ub.set(DEPT_CHECK_STRICTLY, this.getDept_check_strictly(), this.isset_dept_check_strictly);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(TYPE, this.getType(), this.isset_type);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select role_id, role_name, role_key, role_sort, data_scope, menu_check_strictly, dept_check_strictly, status, del_flag, remark, org_id, type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select role_id, role_name, role_key, role_sort, data_scope, menu_check_strictly, dept_check_strictly, status, del_flag, remark, org_id, type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_role mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_role toS_role() {
        return super.$clone();
    }
}

/**
 * s_role RowMapper
 *
 * @author genrator
 */
class S_roleRowMapper implements RowMapper<S_role> {

    @Override
    public S_role mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_role s_role = new S_role();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.ROLE_ID);
        if (columnIndex > 0) {
            s_role.setRole_id(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.ROLE_NAME);
        if (columnIndex > 0) {
            s_role.setRole_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.ROLE_KEY);
        if (columnIndex > 0) {
            s_role.setRole_key(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.ROLE_SORT);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setRole_sort(null);
            } else {
                s_role.setRole_sort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.DATA_SCOPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setData_scope(null);
            } else {
                s_role.setData_scope(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.MENU_CHECK_STRICTLY);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setMenu_check_strictly(null);
            } else {
                s_role.setMenu_check_strictly(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.DEPT_CHECK_STRICTLY);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setDept_check_strictly(null);
            } else {
                s_role.setDept_check_strictly(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setStatus(null);
            } else {
                s_role.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.DEL_FLAG);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setDel_flag(null);
            } else {
                s_role.setDel_flag(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.REMARK);
        if (columnIndex > 0) {
            s_role.setRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.ORG_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setOrg_id(null);
            } else {
                s_role.setOrg_id(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_role_mapper.TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_role.setType(null);
            } else {
                s_role.setType(rs.getInt(columnIndex));
            }
        }
        return s_role;
    }
}
