package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_USER_LOGIN *
 * @author genrator
 */
public class S_user_login_mapper extends S_user_login implements BaseMapper<S_user_login> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_user_login> ROW_MAPPER = new S_user_loginRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String USER_NAME = "user_name";
    public static final String UUID = "uuid";
    public static final String UPDATE_TIME = "update_time";
    public static final String CREATE_TIME = "create_time";
    public static final String CLIENT_TYPE = "client_type";

    /**
     * 默认构造函数
     */
    public S_user_login_mapper(S_user_login s_user_login) {
        if (s_user_login == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_user_login.isset_id) {
            this.setId(s_user_login.getId());
        }
        //普通属性
        if (s_user_login.isset_user_name) {
            this.setUser_name(s_user_login.getUser_name());
        }
        if (s_user_login.isset_uuid) {
            this.setUuid(s_user_login.getUuid());
        }
        if (s_user_login.isset_update_time) {
            this.setUpdate_time(s_user_login.getUpdate_time());
        }
        if (s_user_login.isset_create_time) {
            this.setCreate_time(s_user_login.getCreate_time());
        }
        if (s_user_login.isset_client_type) {
            this.setClient_type(s_user_login.getClient_type());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_user_login.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_user_login";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ib.set(UUID, this.getUuid(), this.isset_uuid);
        ib.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(CLIENT_TYPE, this.getClient_type(), this.isset_client_type);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(UUID, this.getUuid(), this.isset_uuid);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CLIENT_TYPE, this.getClient_type(), this.isset_client_type);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(UUID, this.getUuid(), this.isset_uuid);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CLIENT_TYPE, this.getClient_type(), this.isset_client_type);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(UUID, this.getUuid(), this.isset_uuid);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CLIENT_TYPE, this.getClient_type(), this.isset_client_type);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, user_name, uuid, update_time, create_time, client_type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, user_name, uuid, update_time, create_time, client_type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_user_login mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_user_login toS_user_login() {
        return super.$clone();
    }
}

/**
 * s_user_login RowMapper
 *
 * @author genrator
 */
class S_user_loginRowMapper implements RowMapper<S_user_login> {

    @Override
    public S_user_login mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_user_login s_user_login = new S_user_login();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_user_login_mapper.ID);
        if (columnIndex > 0) {
            s_user_login.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_user_login_mapper.USER_NAME);
        if (columnIndex > 0) {
            s_user_login.setUser_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_login_mapper.UUID);
        if (columnIndex > 0) {
            s_user_login.setUuid(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_login_mapper.UPDATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_login.setUpdate_time(null);
            } else {
                s_user_login.setUpdate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_login_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_login.setCreate_time(null);
            } else {
                s_user_login.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_login_mapper.CLIENT_TYPE);
        if (columnIndex > 0) {
            s_user_login.setClient_type(rs.getString(columnIndex));
        }
        return s_user_login;
    }
}
