
package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:SF_NOTIFICATION *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class SfNotification extends BasePo<SfNotification> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String mark = null;
    @JsonIgnore
    protected boolean isset_mark = false;

    private String type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    private String description = null;
    @JsonIgnore
    protected boolean isset_description = false;

    private Integer isWechat = null;
    @JsonIgnore
    protected boolean isset_isWechat = false;

    private Integer wechatId = null;
    @JsonIgnore
    protected boolean isset_wechatId = false;

    private Integer isRoutine = null;
    @JsonIgnore
    protected boolean isset_isRoutine = false;

    private Integer routineId = null;
    @JsonIgnore
    protected boolean isset_routineId = false;

    private Integer isSms = null;
    @JsonIgnore
    protected boolean isset_isSms = false;

    private Integer smsId = null;
    @JsonIgnore
    protected boolean isset_smsId = false;

    private Integer sendType = null;
    @JsonIgnore
    protected boolean isset_sendType = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    /**
     * 默认构造函数
     */
    public SfNotification() {
    }

    /**
     * 根据主键构造对象
     */
    public SfNotification(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getMark() {
        return this.mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
        this.isset_mark = true;
    }

    @JsonIgnore
    public boolean isEmptyMark() {
        return this.mark == null || this.mark.length() == 0;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.isset_type = true;
    }

    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null || this.type.length() == 0;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.isset_description = true;
    }

    @JsonIgnore
    public boolean isEmptyDescription() {
        return this.description == null || this.description.length() == 0;
    }

    public Integer getIsWechat() {
        return this.isWechat;
    }

    public void setIsWechat(Integer isWechat) {
        this.isWechat = isWechat;
        this.isset_isWechat = true;
    }

    @JsonIgnore
    public boolean isEmptyIsWechat() {
        return this.isWechat == null;
    }

    public Integer getWechatId() {
        return this.wechatId;
    }

    public void setWechatId(Integer wechatId) {
        this.wechatId = wechatId;
        this.isset_wechatId = true;
    }

    @JsonIgnore
    public boolean isEmptyWechatId() {
        return this.wechatId == null;
    }

    public Integer getIsRoutine() {
        return this.isRoutine;
    }

    public void setIsRoutine(Integer isRoutine) {
        this.isRoutine = isRoutine;
        this.isset_isRoutine = true;
    }

    @JsonIgnore
    public boolean isEmptyIsRoutine() {
        return this.isRoutine == null;
    }

    public Integer getRoutineId() {
        return this.routineId;
    }

    public void setRoutineId(Integer routineId) {
        this.routineId = routineId;
        this.isset_routineId = true;
    }

    @JsonIgnore
    public boolean isEmptyRoutineId() {
        return this.routineId == null;
    }

    public Integer getIsSms() {
        return this.isSms;
    }

    public void setIsSms(Integer isSms) {
        this.isSms = isSms;
        this.isset_isSms = true;
    }

    @JsonIgnore
    public boolean isEmptyIsSms() {
        return this.isSms == null;
    }

    public Integer getSmsId() {
        return this.smsId;
    }

    public void setSmsId(Integer smsId) {
        this.smsId = smsId;
        this.isset_smsId = true;
    }

    @JsonIgnore
    public boolean isEmptySmsId() {
        return this.smsId == null;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
        this.isset_sendType = true;
    }

    @JsonIgnore
    public boolean isEmptySendType() {
        return this.sendType == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("mark=").append(this.mark)
                .append("type=").append(this.type)
                .append("description=").append(this.description)
                .append("isWechat=").append(this.isWechat)
                .append("wechatId=").append(this.wechatId)
                .append("isRoutine=").append(this.isRoutine)
                .append("routineId=").append(this.routineId)
                .append("isSms=").append(this.isSms)
                .append("smsId=").append(this.smsId)
                .append("sendType=").append(this.sendType)
                .append("createTime=").append(this.createTime)
                .toString();
    }

    /**
     * 克隆
     */
    public SfNotification $clone() {
        SfNotification sf_notification = new SfNotification();

        // 数据库名称
        //sf_notification.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            sf_notification.setId(this.getId());
        }
        // 普通属性
        if (this.isset_mark) {
            sf_notification.setMark(this.getMark());
        }
        if (this.isset_type) {
            sf_notification.setType(this.getType());
        }
        if (this.isset_description) {
            sf_notification.setDescription(this.getDescription());
        }
        if (this.isset_isWechat) {
            sf_notification.setIsWechat(this.getIsWechat());
        }
        if (this.isset_wechatId) {
            sf_notification.setWechatId(this.getWechatId());
        }
        if (this.isset_isRoutine) {
            sf_notification.setIsRoutine(this.getIsRoutine());
        }
        if (this.isset_routineId) {
            sf_notification.setRoutineId(this.getRoutineId());
        }
        if (this.isset_isSms) {
            sf_notification.setIsSms(this.getIsSms());
        }
        if (this.isset_smsId) {
            sf_notification.setSmsId(this.getSmsId());
        }
        if (this.isset_sendType) {
            sf_notification.setSendType(this.getSendType());
        }
        if (this.isset_createTime) {
            sf_notification.setCreateTime(this.getCreateTime());
        }
        return sf_notification;
    }
}
