package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:SF_NOTIFICATION *
 * @author genrator
 */
public class SfNotification_mapper extends SfNotification implements BaseMapper<SfNotification> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<SfNotification> ROW_MAPPER = new SfNotificationRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Mark = "mark";
    public static final String Type = "type";
    public static final String Description = "description";
    public static final String IsWechat = "is_wechat";
    public static final String WechatId = "wechat_id";
    public static final String IsRoutine = "is_routine";
    public static final String RoutineId = "routine_id";
    public static final String IsSms = "is_sms";
    public static final String SmsId = "sms_id";
    public static final String SendType = "send_type";
    public static final String CreateTime = "create_time";

    /**
     * 默认构造函数
     */
    public SfNotification_mapper(SfNotification sfNotification) {
        if (sfNotification == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (sfNotification.isset_id) {
            this.setId(sfNotification.getId());
        }
        //普通属性
        if (sfNotification.isset_mark) {
            this.setMark(sfNotification.getMark());
        }
        if (sfNotification.isset_type) {
            this.setType(sfNotification.getType());
        }
        if (sfNotification.isset_description) {
            this.setDescription(sfNotification.getDescription());
        }
        if (sfNotification.isset_isWechat) {
            this.setIsWechat(sfNotification.getIsWechat());
        }
        if (sfNotification.isset_wechatId) {
            this.setWechatId(sfNotification.getWechatId());
        }
        if (sfNotification.isset_isRoutine) {
            this.setIsRoutine(sfNotification.getIsRoutine());
        }
        if (sfNotification.isset_routineId) {
            this.setRoutineId(sfNotification.getRoutineId());
        }
        if (sfNotification.isset_isSms) {
            this.setIsSms(sfNotification.getIsSms());
        }
        if (sfNotification.isset_smsId) {
            this.setSmsId(sfNotification.getSmsId());
        }
        if (sfNotification.isset_sendType) {
            this.setSendType(sfNotification.getSendType());
        }
        if (sfNotification.isset_createTime) {
            this.setCreateTime(sfNotification.getCreateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(sf_notification.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "sf_notification";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Mark, this.getMark(), this.isset_mark);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(Description, this.getDescription(), this.isset_description);
        ib.set(IsWechat, this.getIsWechat(), this.isset_isWechat);
        ib.set(WechatId, this.getWechatId(), this.isset_wechatId);
        ib.set(IsRoutine, this.getIsRoutine(), this.isset_isRoutine);
        ib.set(RoutineId, this.getRoutineId(), this.isset_routineId);
        ib.set(IsSms, this.getIsSms(), this.isset_isSms);
        ib.set(SmsId, this.getSmsId(), this.isset_smsId);
        ib.set(SendType, this.getSendType(), this.isset_sendType);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Description, this.getDescription(), this.isset_description);
        ub.set(IsWechat, this.getIsWechat(), this.isset_isWechat);
        ub.set(WechatId, this.getWechatId(), this.isset_wechatId);
        ub.set(IsRoutine, this.getIsRoutine(), this.isset_isRoutine);
        ub.set(RoutineId, this.getRoutineId(), this.isset_routineId);
        ub.set(IsSms, this.getIsSms(), this.isset_isSms);
        ub.set(SmsId, this.getSmsId(), this.isset_smsId);
        ub.set(SendType, this.getSendType(), this.isset_sendType);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Description, this.getDescription(), this.isset_description);
        ub.set(IsWechat, this.getIsWechat(), this.isset_isWechat);
        ub.set(WechatId, this.getWechatId(), this.isset_wechatId);
        ub.set(IsRoutine, this.getIsRoutine(), this.isset_isRoutine);
        ub.set(RoutineId, this.getRoutineId(), this.isset_routineId);
        ub.set(IsSms, this.getIsSms(), this.isset_isSms);
        ub.set(SmsId, this.getSmsId(), this.isset_smsId);
        ub.set(SendType, this.getSendType(), this.isset_sendType);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Description, this.getDescription(), this.isset_description);
        ub.set(IsWechat, this.getIsWechat(), this.isset_isWechat);
        ub.set(WechatId, this.getWechatId(), this.isset_wechatId);
        ub.set(IsRoutine, this.getIsRoutine(), this.isset_isRoutine);
        ub.set(RoutineId, this.getRoutineId(), this.isset_routineId);
        ub.set(IsSms, this.getIsSms(), this.isset_isSms);
        ub.set(SmsId, this.getSmsId(), this.isset_smsId);
        ub.set(SendType, this.getSendType(), this.isset_sendType);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, mark, type, description, is_wechat, wechat_id, is_routine, routine_id, is_sms, sms_id, send_type, create_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, mark, type, description, is_wechat, wechat_id, is_routine, routine_id, is_sms, sms_id, send_type, create_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public SfNotification mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public SfNotification toSfNotification() {
        return super.$clone();
    }
}

/**
 * sf_notification RowMapper
 *
 * @author genrator
 */
class SfNotificationRowMapper implements RowMapper<SfNotification> {

    @Override
    public SfNotification mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        SfNotification sf_notification = new SfNotification();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.Id);
        if (columnIndex > 0) {
            sf_notification.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.Mark);
        if (columnIndex > 0) {
            sf_notification.setMark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.Type);
        if (columnIndex > 0) {
            sf_notification.setType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.Description);
        if (columnIndex > 0) {
            sf_notification.setDescription(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.IsWechat);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setIsWechat(null);
            } else {
                sf_notification.setIsWechat(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.WechatId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setWechatId(null);
            } else {
                sf_notification.setWechatId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.IsRoutine);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setIsRoutine(null);
            } else {
                sf_notification.setIsRoutine(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.RoutineId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setRoutineId(null);
            } else {
                sf_notification.setRoutineId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.IsSms);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setIsSms(null);
            } else {
                sf_notification.setIsSms(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.SmsId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setSmsId(null);
            } else {
                sf_notification.setSmsId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.SendType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setSendType(null);
            } else {
                sf_notification.setSendType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfNotification_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_notification.setCreateTime(null);
            } else {
                sf_notification.setCreateTime(rs.getLong(columnIndex));
            }
        }
        return sf_notification;
    }
}
