package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:SF_TEMPLATE_MESSAGE *
 * @author genrator
 */
public class SfTemplateMessage_mapper extends SfTemplateMessage implements BaseMapper<SfTemplateMessage> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<SfTemplateMessage> ROW_MAPPER = new SfTemplateMessageRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Type = "type";
    public static final String TempKey = "temp_key";
    public static final String Name = "name";
    public static final String Content = "content";
    public static final String TempId = "temp_id";
    public static final String Status = "status";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public SfTemplateMessage_mapper(SfTemplateMessage sfTemplateMessage) {
        if (sfTemplateMessage == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (sfTemplateMessage.isset_id) {
            this.setId(sfTemplateMessage.getId());
        }
        //普通属性
        if (sfTemplateMessage.isset_type) {
            this.setType(sfTemplateMessage.getType());
        }
        if (sfTemplateMessage.isset_tempKey) {
            this.setTempKey(sfTemplateMessage.getTempKey());
        }
        if (sfTemplateMessage.isset_name) {
            this.setName(sfTemplateMessage.getName());
        }
        if (sfTemplateMessage.isset_content) {
            this.setContent(sfTemplateMessage.getContent());
        }
        if (sfTemplateMessage.isset_tempId) {
            this.setTempId(sfTemplateMessage.getTempId());
        }
        if (sfTemplateMessage.isset_status) {
            this.setStatus(sfTemplateMessage.getStatus());
        }
        if (sfTemplateMessage.isset_createTime) {
            this.setCreateTime(sfTemplateMessage.getCreateTime());
        }
        if (sfTemplateMessage.isset_updateTime) {
            this.setUpdateTime(sfTemplateMessage.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(sf_template_message.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "sf_template_message";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(TempKey, this.getTempKey(), this.isset_tempKey);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Content, this.getContent(), this.isset_content);
        ib.set(TempId, this.getTempId(), this.isset_tempId);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(TempKey, this.getTempKey(), this.isset_tempKey);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(TempKey, this.getTempKey(), this.isset_tempKey);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(TempKey, this.getTempKey(), this.isset_tempKey);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, type, temp_key, name, content, temp_id, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, type, temp_key, name, content, temp_id, status, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public SfTemplateMessage mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public SfTemplateMessage toSfTemplateMessage() {
        return super.$clone();
    }
}

/**
 * sf_template_message RowMapper
 *
 * @author genrator
 */
class SfTemplateMessageRowMapper implements RowMapper<SfTemplateMessage> {

    @Override
    public SfTemplateMessage mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        SfTemplateMessage sf_template_message = new SfTemplateMessage();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.Id);
        if (columnIndex > 0) {
            sf_template_message.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_template_message.setType(null);
            } else {
                sf_template_message.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.TempKey);
        if (columnIndex > 0) {
            sf_template_message.setTempKey(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.Name);
        if (columnIndex > 0) {
            sf_template_message.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.Content);
        if (columnIndex > 0) {
            sf_template_message.setContent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.TempId);
        if (columnIndex > 0) {
            sf_template_message.setTempId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_template_message.setStatus(null);
            } else {
                sf_template_message.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_template_message.setCreateTime(null);
            } else {
                sf_template_message.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfTemplateMessage_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_template_message.setUpdateTime(null);
            } else {
                sf_template_message.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return sf_template_message;
    }
}
