
package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:TCP_EQUIP_HISTORY *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class TcpEquipHistory extends BasePo<TcpEquipHistory> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final TcpEquipHistory ROW_MAPPER = new TcpEquipHistory();

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long equipId = null;
    @JsonIgnore
    protected boolean isset_equipId = false;

    private Long startTime = null;
    @JsonIgnore
    protected boolean isset_startTime = false;

    private Long endTime = null;
    @JsonIgnore
    protected boolean isset_endTime = false;

    private Long dataRec = null;
    @JsonIgnore
    protected boolean isset_dataRec = false;

    private Long dataRecTotal = null;
    @JsonIgnore
    protected boolean isset_dataRecTotal = false;

    private Long dataSend = null;
    @JsonIgnore
    protected boolean isset_dataSend = false;

    private Long dataSendTotal = null;
    @JsonIgnore
    protected boolean isset_dataSendTotal = false;

    private Integer year = null;
    @JsonIgnore
    protected boolean isset_year = false;

    private Integer dept = null;
    @JsonIgnore
    protected boolean isset_dept = false;

    private String equipNum = null;
    @JsonIgnore
    protected boolean isset_equipNum = false;

    /**
     * 默认构造函数
     */
    public TcpEquipHistory() {
    }

    /**
     * 根据主键构造对象
     */
    public TcpEquipHistory(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getEquipId() {
        return this.equipId;
    }

    public void setEquipId(Long equipId) {
        this.equipId = equipId;
        this.isset_equipId = true;
    }

    @JsonIgnore
    public boolean isEmptyEquipId() {
        return this.equipId == null;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
        this.isset_startTime = true;
    }

    @JsonIgnore
    public boolean isEmptyStartTime() {
        return this.startTime == null;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
        this.isset_endTime = true;
    }

    @JsonIgnore
    public boolean isEmptyEndTime() {
        return this.endTime == null;
    }

    public Long getDataRec() {
        return this.dataRec;
    }

    public void setDataRec(Long dataRec) {
        this.dataRec = dataRec;
        this.isset_dataRec = true;
    }

    @JsonIgnore
    public boolean isEmptyDataRec() {
        return this.dataRec == null;
    }

    public Long getDataRecTotal() {
        return this.dataRecTotal;
    }

    public void setDataRecTotal(Long dataRecTotal) {
        this.dataRecTotal = dataRecTotal;
        this.isset_dataRecTotal = true;
    }

    @JsonIgnore
    public boolean isEmptyDataRecTotal() {
        return this.dataRecTotal == null;
    }

    public Long getDataSend() {
        return this.dataSend;
    }

    public void setDataSend(Long dataSend) {
        this.dataSend = dataSend;
        this.isset_dataSend = true;
    }

    @JsonIgnore
    public boolean isEmptyDataSend() {
        return this.dataSend == null;
    }

    public Long getDataSendTotal() {
        return this.dataSendTotal;
    }

    public void setDataSendTotal(Long dataSendTotal) {
        this.dataSendTotal = dataSendTotal;
        this.isset_dataSendTotal = true;
    }

    @JsonIgnore
    public boolean isEmptyDataSendTotal() {
        return this.dataSendTotal == null;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
        this.isset_year = true;
    }

    @JsonIgnore
    public boolean isEmptyYear() {
        return this.year == null;
    }

    public Integer getDept() {
        return this.dept;
    }

    public void setDept(Integer dept) {
        this.dept = dept;
        this.isset_dept = true;
    }

    @JsonIgnore
    public boolean isEmptyDept() {
        return this.dept == null;
    }

    public String getEquipNum() {
        return this.equipNum;
    }

    public void setEquipNum(String equipNum) {
        this.equipNum = equipNum;
        this.isset_equipNum = true;
    }

    @JsonIgnore
    public boolean isEmptyEquipNum() {
        return this.equipNum == null || this.equipNum.length() == 0;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("createTime=").append(this.createTime)
                .append("equipId=").append(this.equipId)
                .append("startTime=").append(this.startTime)
                .append("endTime=").append(this.endTime)
                .append("dataRec=").append(this.dataRec)
                .append("dataRecTotal=").append(this.dataRecTotal)
                .append("dataSend=").append(this.dataSend)
                .append("dataSendTotal=").append(this.dataSendTotal)
                .append("year=").append(this.year)
                .append("dept=").append(this.dept)
                .append("equipNum=").append(this.equipNum)
                .toString();
    }

    /**
     * 克隆
     */
    public TcpEquipHistory $clone() {
        TcpEquipHistory tcp_equip_history = new TcpEquipHistory();

        // 数据库名称
        //tcp_equip_history.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            tcp_equip_history.setId(this.getId());
        }
        // 普通属性
        if (this.isset_createTime) {
            tcp_equip_history.setCreateTime(this.getCreateTime());
        }
        if (this.isset_equipId) {
            tcp_equip_history.setEquipId(this.getEquipId());
        }
        if (this.isset_startTime) {
            tcp_equip_history.setStartTime(this.getStartTime());
        }
        if (this.isset_endTime) {
            tcp_equip_history.setEndTime(this.getEndTime());
        }
        if (this.isset_dataRec) {
            tcp_equip_history.setDataRec(this.getDataRec());
        }
        if (this.isset_dataRecTotal) {
            tcp_equip_history.setDataRecTotal(this.getDataRecTotal());
        }
        if (this.isset_dataSend) {
            tcp_equip_history.setDataSend(this.getDataSend());
        }
        if (this.isset_dataSendTotal) {
            tcp_equip_history.setDataSendTotal(this.getDataSendTotal());
        }
        if (this.isset_year) {
            tcp_equip_history.setYear(this.getYear());
        }
        if (this.isset_dept) {
            tcp_equip_history.setDept(this.getDept());
        }
        if (this.isset_equipNum) {
            tcp_equip_history.setEquipNum(this.getEquipNum());
        }
        return tcp_equip_history;
    }
}
