package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_CATEGORY *
 * @author genrator
 */
public class S_category_mapper extends S_category implements BaseMapper<S_category> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_category> ROW_MAPPER = new S_categoryRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String PID = "pid";
    public static final String PATH = "path";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String URL = "url";
    public static final String EXTRA = "extra";
    public static final String STATUS = "status";
    public static final String SORT = "sort";
    public static final String OWNER = "owner";
    public static final String CREATE_TIME = "create_time";
    public static final String UPDATE_TIME = "update_time";

    /**
     * 默认构造函数
     */
    public S_category_mapper(S_category s_category) {
        if (s_category == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_category.isset_id) {
            this.setId(s_category.getId());
        }
        //普通属性
        if (s_category.isset_pid) {
            this.setPid(s_category.getPid());
        }
        if (s_category.isset_path) {
            this.setPath(s_category.getPath());
        }
        if (s_category.isset_name) {
            this.setName(s_category.getName());
        }
        if (s_category.isset_type) {
            this.setType(s_category.getType());
        }
        if (s_category.isset_url) {
            this.setUrl(s_category.getUrl());
        }
        if (s_category.isset_extra) {
            this.setExtra(s_category.getExtra());
        }
        if (s_category.isset_status) {
            this.setStatus(s_category.getStatus());
        }
        if (s_category.isset_sort) {
            this.setSort(s_category.getSort());
        }
        if (s_category.isset_owner) {
            this.setOwner(s_category.getOwner());
        }
        if (s_category.isset_create_time) {
            this.setCreate_time(s_category.getCreate_time());
        }
        if (s_category.isset_update_time) {
            this.setUpdate_time(s_category.getUpdate_time());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_category.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_category";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(PID, this.getPid(), this.isset_pid);
        ib.set(PATH, this.getPath(), this.isset_path);
        ib.set(NAME, this.getName(), this.isset_name);
        ib.set(TYPE, this.getType(), this.isset_type);
        ib.set(URL, this.getUrl(), this.isset_url);
        ib.set(EXTRA, this.getExtra(), this.isset_extra);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(SORT, this.getSort(), this.isset_sort);
        ib.set(OWNER, this.getOwner(), this.isset_owner);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PID, this.getPid(), this.isset_pid);
        ub.set(PATH, this.getPath(), this.isset_path);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(URL, this.getUrl(), this.isset_url);
        ub.set(EXTRA, this.getExtra(), this.isset_extra);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(OWNER, this.getOwner(), this.isset_owner);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PID, this.getPid(), this.isset_pid);
        ub.set(PATH, this.getPath(), this.isset_path);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(URL, this.getUrl(), this.isset_url);
        ub.set(EXTRA, this.getExtra(), this.isset_extra);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(OWNER, this.getOwner(), this.isset_owner);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PID, this.getPid(), this.isset_pid);
        ub.set(PATH, this.getPath(), this.isset_path);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(URL, this.getUrl(), this.isset_url);
        ub.set(EXTRA, this.getExtra(), this.isset_extra);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(SORT, this.getSort(), this.isset_sort);
        ub.set(OWNER, this.getOwner(), this.isset_owner);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, pid, path, name, type, url, extra, status, sort, owner, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, pid, path, name, type, url, extra, status, sort, owner, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_category mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_category toS_category() {
        return super.$clone();
    }
}

/**
 * s_category RowMapper
 *
 * @author genrator
 */
class S_categoryRowMapper implements RowMapper<S_category> {

    @Override
    public S_category mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_category s_category = new S_category();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.ID);
        if (columnIndex > 0) {
            s_category.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.PID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_category.setPid(null);
            } else {
                s_category.setPid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.PATH);
        if (columnIndex > 0) {
            s_category.setPath(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.NAME);
        if (columnIndex > 0) {
            s_category.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_category.setType(null);
            } else {
                s_category.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.URL);
        if (columnIndex > 0) {
            s_category.setUrl(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.EXTRA);
        if (columnIndex > 0) {
            s_category.setExtra(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_category.setStatus(null);
            } else {
                s_category.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.SORT);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_category.setSort(null);
            } else {
                s_category.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.OWNER);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_category.setOwner(null);
            } else {
                s_category.setOwner(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_category.setCreate_time(null);
            } else {
                s_category.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_category_mapper.UPDATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_category.setUpdate_time(null);
            } else {
                s_category.setUpdate_time(rs.getLong(columnIndex));
            }
        }
        return s_category;
    }
}
