package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:S_CLASS_EXT *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class S_class_ext extends BasePo<S_class_ext> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final S_class_ext ROW_MAPPER = new S_class_ext();

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private String description = null;
    @JsonIgnore
    protected boolean isset_description = false;

    private String type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    /**
     * 默认构造函数
     */
    public S_class_ext() {
    }

    /**
     * 根据主键构造对象
     */
    public S_class_ext(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.isset_description = true;
    }

    @JsonIgnore
    public boolean isEmptyDescription() {
        return this.description == null || this.description.length() == 0;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.isset_type = true;
    }

    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null || this.type.length() == 0;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("name=").append(this.name)
                .append("description=").append(this.description)
                .append("type=").append(this.type)
                .toString();
    }

    /**
     * 克隆
     */
    public S_class_ext $clone() {
        S_class_ext s_class_ext = new S_class_ext();

        // 数据库名称
        //s_class_ext.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            s_class_ext.setId(this.getId());
        }
        // 普通属性
        if (this.isset_name) {
            s_class_ext.setName(this.getName());
        }
        if (this.isset_description) {
            s_class_ext.setDescription(this.getDescription());
        }
        if (this.isset_type) {
            s_class_ext.setType(this.getType());
        }
        return s_class_ext;
    }
}
