

package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:S_CONFIG *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class S_config extends BasePo<S_config> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final S_config ROW_MAPPER = new S_config();

    // 主键
    private Long config_id = null;
    @JsonIgnore
    protected boolean isset_config_id = false;

    // 属性列表
    private String config_name = null;
    @JsonIgnore
    protected boolean isset_config_name = false;

    private String config_key = null;
    @JsonIgnore
    protected boolean isset_config_key = false;

    private String config_value = null;
    @JsonIgnore
    protected boolean isset_config_value = false;

    private String config_type = null;
    @JsonIgnore
    protected boolean isset_config_type = false;

    private Long create_time = null;
    @JsonIgnore
    protected boolean isset_create_time = false;

    private String remark = null;
    @JsonIgnore
    protected boolean isset_remark = false;

    private String data_type = null;
    @JsonIgnore
    protected boolean isset_data_type = false;

    private String group_id = null;
    @JsonIgnore
    protected boolean isset_group_id = false;

    private Integer form_id = null;
    @JsonIgnore
    protected boolean isset_form_id = false;

    /**
     * 默认构造函数
     */
    public S_config() {
    }

    /**
     * 根据主键构造对象
     */
    public S_config(Long config_id) {
        this.setConfig_id(config_id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setConfig_id((Long) value);
    }

            public Long getConfig_id() {
        return this.config_id;
    }
    public void setConfig_id(Long config_id) {
        this.config_id = config_id;
        this.isset_config_id = true;
    }
    @JsonIgnore
    public boolean isEmptyConfig_id() {
        return this.config_id == null;
    }


    public String getConfig_name() {
        return this.config_name;
    }
    public void setConfig_name(String config_name) {
        this.config_name = config_name;
        this.isset_config_name = true;
        // config_name, varchar
    }
    @JsonIgnore
    public boolean isEmptyConfig_name() {
        return this.config_name == null || this.config_name.length() == 0;
    }


    public String getConfig_key() {
        return this.config_key;
    }
    public void setConfig_key(String config_key) {
        this.config_key = config_key;
        this.isset_config_key = true;
        // config_key, varchar
    }
    @JsonIgnore
    public boolean isEmptyConfig_key() {
        return this.config_key == null || this.config_key.length() == 0;
    }


    public String getConfig_value() {
        return this.config_value;
    }
    public void setConfig_value(String config_value) {
        this.config_value = config_value;
        this.isset_config_value = true;
        // config_value, varchar
    }
    @JsonIgnore
    public boolean isEmptyConfig_value() {
        return this.config_value == null || this.config_value.length() == 0;
    }


    public String getConfig_type() {
        return this.config_type;
    }
    public void setConfig_type(String config_type) {
        this.config_type = config_type;
        this.isset_config_type = true;
        // config_type, varchar
    }
    @JsonIgnore
    public boolean isEmptyConfig_type() {
        return this.config_type == null || this.config_type.length() == 0;
    }


    public Long getCreate_time() {
        return this.create_time;
    }
    public void setCreate_time(Long create_time) {
        this.create_time = create_time;
        this.isset_create_time = true;
        // create_time, bigint
    }
    @JsonIgnore
    public boolean isEmptyCreate_time() {
        return this.create_time == null;
    }


    public String getRemark() {
        return this.remark;
    }
    public void setRemark(String remark) {
        this.remark = remark;
        this.isset_remark = true;
        // remark, varchar
    }
    @JsonIgnore
    public boolean isEmptyRemark() {
        return this.remark == null || this.remark.length() == 0;
    }


    public String getData_type() {
        return this.data_type;
    }
    public void setData_type(String data_type) {
        this.data_type = data_type;
        this.isset_data_type = true;
        // data_type, varchar
    }
    @JsonIgnore
    public boolean isEmptyData_type() {
        return this.data_type == null || this.data_type.length() == 0;
    }


    public String getGroup_id() {
        return this.group_id;
    }
    public void setGroup_id(String group_id) {
        this.group_id = group_id;
        this.isset_group_id = true;
        // group_id, varchar
    }
    @JsonIgnore
    public boolean isEmptyGroup_id() {
        return this.group_id == null || this.group_id.length() == 0;
    }


    public Integer getForm_id() {
        return this.form_id;
    }
    public void setForm_id(Integer form_id) {
        this.form_id = form_id;
        this.isset_form_id = true;
        // form_id, int
    }
    @JsonIgnore
    public boolean isEmptyForm_id() {
        return this.form_id == null;
    }


    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("config_id=").append(this.config_id)
                .append("config_name=").append(this.config_name)
                .append("config_key=").append(this.config_key)
                .append("config_value=").append(this.config_value)
                .append("config_type=").append(this.config_type)
                .append("create_time=").append(this.create_time)
                .append("remark=").append(this.remark)
                .append("data_type=").append(this.data_type)
                .append("group_id=").append(this.group_id)
                .append("form_id=").append(this.form_id)
                .toString();
    }

    /**
     * 克隆
     */
    public S_config $clone() {
        S_config s_config = new S_config();

        // 数据库名称
        //s_config.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_config_id) {
            s_config.setConfig_id(this.getConfig_id());
        }
        // 普通属性
        if (this.isset_config_name) {
            s_config.setConfig_name(this.getConfig_name());
        }
        if (this.isset_config_key) {
            s_config.setConfig_key(this.getConfig_key());
        }
        if (this.isset_config_value) {
            s_config.setConfig_value(this.getConfig_value());
        }
        if (this.isset_config_type) {
            s_config.setConfig_type(this.getConfig_type());
        }
        if (this.isset_create_time) {
            s_config.setCreate_time(this.getCreate_time());
        }
        if (this.isset_remark) {
            s_config.setRemark(this.getRemark());
        }
        if (this.isset_data_type) {
            s_config.setData_type(this.getData_type());
        }
        if (this.isset_group_id) {
            s_config.setGroup_id(this.getGroup_id());
        }
        if (this.isset_form_id) {
            s_config.setForm_id(this.getForm_id());
        }
        return s_config;
    }
}
