package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_CONFIG_FORM *
 * @author genrator
 */
public class S_config_form_mapper extends S_config_form implements BaseMapper<S_config_form> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_config_form> ROW_MAPPER = new S_config_formRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String NAME = "name";
    public static final String INFO = "info";
    public static final String CONTENT = "content";
    public static final String CREATE_TIME = "create_time";
    public static final String UPDATE_TIME = "update_time";

    /**
     * 默认构造函数
     */
    public S_config_form_mapper(S_config_form s_config_form) {
        if (s_config_form == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_config_form.isset_id) {
            this.setId(s_config_form.getId());
        }
        //普通属性
        if (s_config_form.isset_name) {
            this.setName(s_config_form.getName());
        }
        if (s_config_form.isset_info) {
            this.setInfo(s_config_form.getInfo());
        }
        if (s_config_form.isset_content) {
            this.setContent(s_config_form.getContent());
        }
        if (s_config_form.isset_create_time) {
            this.setCreate_time(s_config_form.getCreate_time());
        }
        if (s_config_form.isset_update_time) {
            this.setUpdate_time(s_config_form.getUpdate_time());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_config_form.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_config_form";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(NAME, this.getName(), this.isset_name);
        ib.set(INFO, this.getInfo(), this.isset_info);
        ib.set(CONTENT, this.getContent(), this.isset_content);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(INFO, this.getInfo(), this.isset_info);
        ub.set(CONTENT, this.getContent(), this.isset_content);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(INFO, this.getInfo(), this.isset_info);
        ub.set(CONTENT, this.getContent(), this.isset_content);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(INFO, this.getInfo(), this.isset_info);
        ub.set(CONTENT, this.getContent(), this.isset_content);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(UPDATE_TIME, this.getUpdate_time(), this.isset_update_time);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, name, info, content, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, name, info, content, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_config_form mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_config_form toS_config_form() {
        return super.$clone();
    }
}

/**
 * s_config_form RowMapper
 *
 * @author genrator
 */
class S_config_formRowMapper implements RowMapper<S_config_form> {

    @Override
    public S_config_form mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_config_form s_config_form = new S_config_form();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_config_form_mapper.ID);
        if (columnIndex > 0) {
            s_config_form.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_config_form_mapper.NAME);
        if (columnIndex > 0) {
            s_config_form.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_form_mapper.INFO);
        if (columnIndex > 0) {
            s_config_form.setInfo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_form_mapper.CONTENT);
        if (columnIndex > 0) {
            s_config_form.setContent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_form_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_config_form.setCreate_time(null);
            } else {
                s_config_form.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_config_form_mapper.UPDATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_config_form.setUpdate_time(null);
            } else {
                s_config_form.setUpdate_time(rs.getLong(columnIndex));
            }
        }
        return s_config_form;
    }
}
