package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_DEPT *
 * @author genrator
 */
public class S_dept_mapper extends S_dept implements BaseMapper<S_dept> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_dept> ROW_MAPPER = new S_deptRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String PARENT_ID = "parent_id";
    public static final String ORG_ID = "org_id";
    public static final String ANCESTORS = "ancestors";
    public static final String DEPT_NAME = "dept_name";
    public static final String ORDER_NUM = "order_num";
    public static final String LEADER = "leader";
    public static final String PHONE = "phone";
    public static final String EMAIL = "email";
    public static final String STATUS = "status";
    public static final String DEL_FLAG = "del_flag";
    public static final String CREATE_BY = "create_by";
    public static final String CREATE_TIME = "create_time";
    public static final String ATTRIBUTE = "attribute";
    public static final String ORG_TYPE = "org_type";
    public static final String CHARGE_MAN = "charge_man";
    public static final String MENU_TYPE = "menu_type";

    /**
     * 默认构造函数
     */
    public S_dept_mapper(S_dept s_dept) {
        if (s_dept == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_dept.isset_id) {
            this.setId(s_dept.getId());
        }
        //普通属性
        if (s_dept.isset_parent_id) {
            this.setParent_id(s_dept.getParent_id());
        }
        if (s_dept.isset_org_id) {
            this.setOrg_id(s_dept.getOrg_id());
        }
        if (s_dept.isset_ancestors) {
            this.setAncestors(s_dept.getAncestors());
        }
        if (s_dept.isset_dept_name) {
            this.setDept_name(s_dept.getDept_name());
        }
        if (s_dept.isset_order_num) {
            this.setOrder_num(s_dept.getOrder_num());
        }
        if (s_dept.isset_leader) {
            this.setLeader(s_dept.getLeader());
        }
        if (s_dept.isset_phone) {
            this.setPhone(s_dept.getPhone());
        }
        if (s_dept.isset_email) {
            this.setEmail(s_dept.getEmail());
        }
        if (s_dept.isset_status) {
            this.setStatus(s_dept.getStatus());
        }
        if (s_dept.isset_del_flag) {
            this.setDel_flag(s_dept.getDel_flag());
        }
        if (s_dept.isset_create_by) {
            this.setCreate_by(s_dept.getCreate_by());
        }
        if (s_dept.isset_create_time) {
            this.setCreate_time(s_dept.getCreate_time());
        }
        if (s_dept.isset_attribute) {
            this.setAttribute(s_dept.getAttribute());
        }
        if (s_dept.isset_org_type) {
            this.setOrg_type(s_dept.getOrg_type());
        }
        if (s_dept.isset_charge_man) {
            this.setCharge_man(s_dept.getCharge_man());
        }
        if (s_dept.isset_menu_type) {
            this.setMenu_type(s_dept.getMenu_type());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_dept.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_dept";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ib.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ib.set(ANCESTORS, this.getAncestors(), this.isset_ancestors);
        ib.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ib.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ib.set(LEADER, this.getLeader(), this.isset_leader);
        ib.set(PHONE, this.getPhone(), this.isset_phone);
        ib.set(EMAIL, this.getEmail(), this.isset_email);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ib.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(ATTRIBUTE, this.getAttribute(), this.isset_attribute);
        ib.set(ORG_TYPE, this.getOrg_type(), this.isset_org_type);
        ib.set(CHARGE_MAN, this.getCharge_man(), this.isset_charge_man);
        ib.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(ANCESTORS, this.getAncestors(), this.isset_ancestors);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ub.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ub.set(LEADER, this.getLeader(), this.isset_leader);
        ub.set(PHONE, this.getPhone(), this.isset_phone);
        ub.set(EMAIL, this.getEmail(), this.isset_email);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(ATTRIBUTE, this.getAttribute(), this.isset_attribute);
        ub.set(ORG_TYPE, this.getOrg_type(), this.isset_org_type);
        ub.set(CHARGE_MAN, this.getCharge_man(), this.isset_charge_man);
        ub.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(ANCESTORS, this.getAncestors(), this.isset_ancestors);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ub.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ub.set(LEADER, this.getLeader(), this.isset_leader);
        ub.set(PHONE, this.getPhone(), this.isset_phone);
        ub.set(EMAIL, this.getEmail(), this.isset_email);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(ATTRIBUTE, this.getAttribute(), this.isset_attribute);
        ub.set(ORG_TYPE, this.getOrg_type(), this.isset_org_type);
        ub.set(CHARGE_MAN, this.getCharge_man(), this.isset_charge_man);
        ub.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(ANCESTORS, this.getAncestors(), this.isset_ancestors);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ub.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ub.set(LEADER, this.getLeader(), this.isset_leader);
        ub.set(PHONE, this.getPhone(), this.isset_phone);
        ub.set(EMAIL, this.getEmail(), this.isset_email);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(DEL_FLAG, this.getDel_flag(), this.isset_del_flag);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(ATTRIBUTE, this.getAttribute(), this.isset_attribute);
        ub.set(ORG_TYPE, this.getOrg_type(), this.isset_org_type);
        ub.set(CHARGE_MAN, this.getCharge_man(), this.isset_charge_man);
        ub.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, parent_id, org_id, ancestors, dept_name, order_num, leader, phone, email, status, del_flag, create_by, create_time, attribute, org_type, charge_man, menu_type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, parent_id, org_id, ancestors, dept_name, order_num, leader, phone, email, status, del_flag, create_by, create_time, attribute, org_type, charge_man, menu_type from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_dept mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_dept toS_dept() {
        return super.$clone();
    }
}

/**
 * s_dept RowMapper
 *
 * @author genrator
 */
class S_deptRowMapper implements RowMapper<S_dept> {

    @Override
    public S_dept mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_dept s_dept = new S_dept();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.ID);
        if (columnIndex > 0) {
            s_dept.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.PARENT_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setParent_id(null);
            } else {
                s_dept.setParent_id(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.ORG_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setOrg_id(null);
            } else {
                s_dept.setOrg_id(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.ANCESTORS);
        if (columnIndex > 0) {
            s_dept.setAncestors(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.DEPT_NAME);
        if (columnIndex > 0) {
            s_dept.setDept_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.ORDER_NUM);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setOrder_num(null);
            } else {
                s_dept.setOrder_num(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.LEADER);
        if (columnIndex > 0) {
            s_dept.setLeader(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.PHONE);
        if (columnIndex > 0) {
            s_dept.setPhone(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.EMAIL);
        if (columnIndex > 0) {
            s_dept.setEmail(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setStatus(null);
            } else {
                s_dept.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.DEL_FLAG);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setDel_flag(null);
            } else {
                s_dept.setDel_flag(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.CREATE_BY);
        if (columnIndex > 0) {
            s_dept.setCreate_by(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setCreate_time(null);
            } else {
                s_dept.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.ATTRIBUTE);
        if (columnIndex > 0) {
            s_dept.setAttribute(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.ORG_TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setOrg_type(null);
            } else {
                s_dept.setOrg_type(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.CHARGE_MAN);
        if (columnIndex > 0) {
            s_dept.setCharge_man(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dept_mapper.MENU_TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dept.setMenu_type(null);
            } else {
                s_dept.setMenu_type(rs.getInt(columnIndex));
            }
        }
        return s_dept;
    }
}
