package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_DICT_TYPE *
 * @author genrator
 */
public class S_dict_type_mapper extends S_dict_type implements BaseMapper<S_dict_type> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_dict_type> ROW_MAPPER = new S_dict_typeRowMapper();

    // 主键
    public static final String DICT_ID = "dict_id";
    // 普通属性
    public static final String DICT_NAME = "dict_name";
    public static final String DICT_TYPE = "dict_type";
    public static final String STATUS = "status";
    public static final String CREATE_BY = "create_by";
    public static final String CREATE_TIME = "create_time";
    public static final String REMARK = "remark";

    /**
     * 默认构造函数
     */
    public S_dict_type_mapper(S_dict_type s_dict_type) {
        if (s_dict_type == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_dict_type.isset_dict_id) {
            this.setDict_id(s_dict_type.getDict_id());
        }
        //普通属性
        if (s_dict_type.isset_dict_name) {
            this.setDict_name(s_dict_type.getDict_name());
        }
        if (s_dict_type.isset_dict_type) {
            this.setDict_type(s_dict_type.getDict_type());
        }
        if (s_dict_type.isset_status) {
            this.setStatus(s_dict_type.getStatus());
        }
        if (s_dict_type.isset_create_by) {
            this.setCreate_by(s_dict_type.getCreate_by());
        }
        if (s_dict_type.isset_create_time) {
            this.setCreate_time(s_dict_type.getCreate_time());
        }
        if (s_dict_type.isset_remark) {
            this.setRemark(s_dict_type.getRemark());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_dict_type.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_dict_type";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return DICT_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getDict_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(DICT_ID, this.getDict_id());
        ib.set(DICT_NAME, this.getDict_name(), this.isset_dict_name);
        ib.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(REMARK, this.getRemark(), this.isset_remark);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(DICT_NAME, this.getDict_name(), this.isset_dict_name);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(DICT_NAME, this.getDict_name(), this.isset_dict_name);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(DICT_NAME, this.getDict_name(), this.isset_dict_name);
        ub.set(DICT_TYPE, this.getDict_type(), this.isset_dict_type);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(CREATE_BY, this.getCreate_by(), this.isset_create_by);
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(REMARK, this.getRemark(), this.isset_remark);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select dict_id, dict_name, dict_type, status, create_by, create_time, remark from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select dict_id, dict_name, dict_type, status, create_by, create_time, remark from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_dict_type mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_dict_type toS_dict_type() {
        return super.$clone();
    }
}

/**
 * s_dict_type RowMapper
 *
 * @author genrator
 */
class S_dict_typeRowMapper implements RowMapper<S_dict_type> {

    @Override
    public S_dict_type mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_dict_type s_dict_type = new S_dict_type();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_dict_type_mapper.DICT_ID);
        if (columnIndex > 0) {
            s_dict_type.setDict_id(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_dict_type_mapper.DICT_NAME);
        if (columnIndex > 0) {
            s_dict_type.setDict_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_type_mapper.DICT_TYPE);
        if (columnIndex > 0) {
            s_dict_type.setDict_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_type_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dict_type.setStatus(null);
            } else {
                s_dict_type.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_type_mapper.CREATE_BY);
        if (columnIndex > 0) {
            s_dict_type.setCreate_by(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_type_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_dict_type.setCreate_time(null);
            } else {
                s_dict_type.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_dict_type_mapper.REMARK);
        if (columnIndex > 0) {
            s_dict_type.setRemark(rs.getString(columnIndex));
        }
        return s_dict_type;
    }
}
