package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_HOST *
 * @author genrator
 */
public class S_host_mapper extends S_host implements BaseMapper<S_host> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_host> ROW_MAPPER = new S_hostRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String CREATE_TIME = "create_time";
    public static final String CREATE_USER = "create_user";
    public static final String URL = "url";
    public static final String PORT = "port";
    public static final String SERVICE_NAME = "service_name";
    public static final String AUTHENTICATION = "authentication";
    public static final String CERTIFICATION = "certification";
    public static final String MAX_ACTIVE = "max_active";

    /**
     * 默认构造函数
     */
    public S_host_mapper(S_host s_host) {
        if (s_host == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_host.isset_id) {
            this.setId(s_host.getId());
        }
        //普通属性
        if (s_host.isset_create_time) {
            this.setCreate_time(s_host.getCreate_time());
        }
        if (s_host.isset_create_user) {
            this.setCreate_user(s_host.getCreate_user());
        }
        if (s_host.isset_url) {
            this.setUrl(s_host.getUrl());
        }
        if (s_host.isset_port) {
            this.setPort(s_host.getPort());
        }
        if (s_host.isset_service_name) {
            this.setService_name(s_host.getService_name());
        }
        if (s_host.isset_authentication) {
            this.setAuthentication(s_host.getAuthentication());
        }
        if (s_host.isset_certification) {
            this.setCertification(s_host.getCertification());
        }
        if (s_host.isset_max_active) {
            this.setMax_active(s_host.getMax_active());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_host.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_host";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(CREATE_USER, this.getCreate_user(), this.isset_create_user);
        ib.set(URL, this.getUrl(), this.isset_url);
        ib.set(PORT, this.getPort(), this.isset_port);
        ib.set(SERVICE_NAME, this.getService_name(), this.isset_service_name);
        ib.set(AUTHENTICATION, this.getAuthentication(), this.isset_authentication);
        ib.set(CERTIFICATION, this.getCertification(), this.isset_certification);
        ib.set(MAX_ACTIVE, this.getMax_active(), this.isset_max_active);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CREATE_USER, this.getCreate_user(), this.isset_create_user);
        ub.set(URL, this.getUrl(), this.isset_url);
        ub.set(PORT, this.getPort(), this.isset_port);
        ub.set(SERVICE_NAME, this.getService_name(), this.isset_service_name);
        ub.set(AUTHENTICATION, this.getAuthentication(), this.isset_authentication);
        ub.set(CERTIFICATION, this.getCertification(), this.isset_certification);
        ub.set(MAX_ACTIVE, this.getMax_active(), this.isset_max_active);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CREATE_USER, this.getCreate_user(), this.isset_create_user);
        ub.set(URL, this.getUrl(), this.isset_url);
        ub.set(PORT, this.getPort(), this.isset_port);
        ub.set(SERVICE_NAME, this.getService_name(), this.isset_service_name);
        ub.set(AUTHENTICATION, this.getAuthentication(), this.isset_authentication);
        ub.set(CERTIFICATION, this.getCertification(), this.isset_certification);
        ub.set(MAX_ACTIVE, this.getMax_active(), this.isset_max_active);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(CREATE_USER, this.getCreate_user(), this.isset_create_user);
        ub.set(URL, this.getUrl(), this.isset_url);
        ub.set(PORT, this.getPort(), this.isset_port);
        ub.set(SERVICE_NAME, this.getService_name(), this.isset_service_name);
        ub.set(AUTHENTICATION, this.getAuthentication(), this.isset_authentication);
        ub.set(CERTIFICATION, this.getCertification(), this.isset_certification);
        ub.set(MAX_ACTIVE, this.getMax_active(), this.isset_max_active);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, create_user, url, port, service_name, authentication, certification, max_active from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, create_user, url, port, service_name, authentication, certification, max_active from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_host mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_host toS_host() {
        return super.$clone();
    }
}

/**
 * s_host RowMapper
 *
 * @author genrator
 */
class S_hostRowMapper implements RowMapper<S_host> {

    @Override
    public S_host mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_host s_host = new S_host();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.ID);
        if (columnIndex > 0) {
            s_host.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_host.setCreate_time(null);
            } else {
                s_host.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.CREATE_USER);
        if (columnIndex > 0) {
            s_host.setCreate_user(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.URL);
        if (columnIndex > 0) {
            s_host.setUrl(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.PORT);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_host.setPort(null);
            } else {
                s_host.setPort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.SERVICE_NAME);
        if (columnIndex > 0) {
            s_host.setService_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.AUTHENTICATION);
        if (columnIndex > 0) {
            s_host.setAuthentication(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.CERTIFICATION);
        if (columnIndex > 0) {
            s_host.setCertification(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_host_mapper.MAX_ACTIVE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_host.setMax_active(null);
            } else {
                s_host.setMax_active(rs.getInt(columnIndex));
            }
        }
        return s_host;
    }
}
