package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:S_LOGIN_INFO *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class S_login_info extends BasePo<S_login_info> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final S_login_info ROW_MAPPER = new S_login_info();

    // 主键
    private Long info_id = null;
    @JsonIgnore
    protected boolean isset_info_id = false;

    // 属性列表
    private String user_name = null;
    @JsonIgnore
    protected boolean isset_user_name = false;

    private String ipaddr = null;
    @JsonIgnore
    protected boolean isset_ipaddr = false;

    private String login_location = null;
    @JsonIgnore
    protected boolean isset_login_location = false;

    private String browser = null;
    @JsonIgnore
    protected boolean isset_browser = false;

    private String os = null;
    @JsonIgnore
    protected boolean isset_os = false;

    private String status = null;
    @JsonIgnore
    protected boolean isset_status = false;

    private String msg = null;
    @JsonIgnore
    protected boolean isset_msg = false;

    private Long login_time = null;
    @JsonIgnore
    protected boolean isset_login_time = false;

    /**
     * 默认构造函数
     */
    public S_login_info() {
    }

    /**
     * 根据主键构造对象
     */
    public S_login_info(Long info_id) {
        this.setInfo_id(info_id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setInfo_id((Long) value);
    }

    public Long getInfo_id() {
        return this.info_id;
    }

    public void setInfo_id(Long info_id) {
        this.info_id = info_id;
        this.isset_info_id = true;
    }

    @JsonIgnore
    public boolean isEmptyInfo_id() {
        return this.info_id == null;
    }

    public String getUser_name() {
        return this.user_name;
    }

    public void setUser_name(String user_name) {
        this.user_name = user_name;
        this.isset_user_name = true;
    }

    @JsonIgnore
    public boolean isEmptyUser_name() {
        return this.user_name == null || this.user_name.length() == 0;
    }

    public String getIpaddr() {
        return this.ipaddr;
    }

    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
        this.isset_ipaddr = true;
    }

    @JsonIgnore
    public boolean isEmptyIpaddr() {
        return this.ipaddr == null || this.ipaddr.length() == 0;
    }

    public String getLogin_location() {
        return this.login_location;
    }

    public void setLogin_location(String login_location) {
        this.login_location = login_location;
        this.isset_login_location = true;
    }

    @JsonIgnore
    public boolean isEmptyLogin_location() {
        return this.login_location == null || this.login_location.length() == 0;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
        this.isset_browser = true;
    }

    @JsonIgnore
    public boolean isEmptyBrowser() {
        return this.browser == null || this.browser.length() == 0;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
        this.isset_os = true;
    }

    @JsonIgnore
    public boolean isEmptyOs() {
        return this.os == null || this.os.length() == 0;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        this.isset_status = true;
    }

    @JsonIgnore
    public boolean isEmptyStatus() {
        return this.status == null || this.status.length() == 0;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
        this.isset_msg = true;
    }

    @JsonIgnore
    public boolean isEmptyMsg() {
        return this.msg == null || this.msg.length() == 0;
    }

    public Long getLogin_time() {
        return this.login_time;
    }

    public void setLogin_time(Long login_time) {
        this.login_time = login_time;
        this.isset_login_time = true;
    }

    @JsonIgnore
    public boolean isEmptyLogin_time() {
        return this.login_time == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("info_id=").append(this.info_id)
                .append("user_name=").append(this.user_name)
                .append("ipaddr=").append(this.ipaddr)
                .append("login_location=").append(this.login_location)
                .append("browser=").append(this.browser)
                .append("os=").append(this.os)
                .append("status=").append(this.status)
                .append("msg=").append(this.msg)
                .append("login_time=").append(this.login_time)
                .toString();
    }

    /**
     * 克隆
     */
    public S_login_info $clone() {
        S_login_info s_login_info = new S_login_info();

        // 数据库名称
        //s_login_info.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_info_id) {
            s_login_info.setInfo_id(this.getInfo_id());
        }
        // 普通属性
        if (this.isset_user_name) {
            s_login_info.setUser_name(this.getUser_name());
        }
        if (this.isset_ipaddr) {
            s_login_info.setIpaddr(this.getIpaddr());
        }
        if (this.isset_login_location) {
            s_login_info.setLogin_location(this.getLogin_location());
        }
        if (this.isset_browser) {
            s_login_info.setBrowser(this.getBrowser());
        }
        if (this.isset_os) {
            s_login_info.setOs(this.getOs());
        }
        if (this.isset_status) {
            s_login_info.setStatus(this.getStatus());
        }
        if (this.isset_msg) {
            s_login_info.setMsg(this.getMsg());
        }
        if (this.isset_login_time) {
            s_login_info.setLogin_time(this.getLogin_time());
        }
        return s_login_info;
    }
}
