package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_LOGIN_INFO *
 * @author genrator
 */
public class S_login_info_mapper extends S_login_info implements BaseMapper<S_login_info> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_login_info> ROW_MAPPER = new S_login_infoRowMapper();

    // 主键
    public static final String INFO_ID = "info_id";
    // 普通属性
    public static final String USER_NAME = "user_name";
    public static final String IPADDR = "ipaddr";
    public static final String LOGIN_LOCATION = "login_location";
    public static final String BROWSER = "browser";
    public static final String OS = "os";
    public static final String STATUS = "status";
    public static final String MSG = "msg";
    public static final String LOGIN_TIME = "login_time";

    /**
     * 默认构造函数
     */
    public S_login_info_mapper(S_login_info s_login_info) {
        if (s_login_info == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_login_info.isset_info_id) {
            this.setInfo_id(s_login_info.getInfo_id());
        }
        //普通属性
        if (s_login_info.isset_user_name) {
            this.setUser_name(s_login_info.getUser_name());
        }
        if (s_login_info.isset_ipaddr) {
            this.setIpaddr(s_login_info.getIpaddr());
        }
        if (s_login_info.isset_login_location) {
            this.setLogin_location(s_login_info.getLogin_location());
        }
        if (s_login_info.isset_browser) {
            this.setBrowser(s_login_info.getBrowser());
        }
        if (s_login_info.isset_os) {
            this.setOs(s_login_info.getOs());
        }
        if (s_login_info.isset_status) {
            this.setStatus(s_login_info.getStatus());
        }
        if (s_login_info.isset_msg) {
            this.setMsg(s_login_info.getMsg());
        }
        if (s_login_info.isset_login_time) {
            this.setLogin_time(s_login_info.getLogin_time());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_login_info.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_login_info";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return INFO_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getInfo_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(INFO_ID, this.getInfo_id());
        ib.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ib.set(IPADDR, this.getIpaddr(), this.isset_ipaddr);
        ib.set(LOGIN_LOCATION, this.getLogin_location(), this.isset_login_location);
        ib.set(BROWSER, this.getBrowser(), this.isset_browser);
        ib.set(OS, this.getOs(), this.isset_os);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(MSG, this.getMsg(), this.isset_msg);
        ib.set(LOGIN_TIME, this.getLogin_time(), this.isset_login_time);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(IPADDR, this.getIpaddr(), this.isset_ipaddr);
        ub.set(LOGIN_LOCATION, this.getLogin_location(), this.isset_login_location);
        ub.set(BROWSER, this.getBrowser(), this.isset_browser);
        ub.set(OS, this.getOs(), this.isset_os);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(MSG, this.getMsg(), this.isset_msg);
        ub.set(LOGIN_TIME, this.getLogin_time(), this.isset_login_time);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(IPADDR, this.getIpaddr(), this.isset_ipaddr);
        ub.set(LOGIN_LOCATION, this.getLogin_location(), this.isset_login_location);
        ub.set(BROWSER, this.getBrowser(), this.isset_browser);
        ub.set(OS, this.getOs(), this.isset_os);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(MSG, this.getMsg(), this.isset_msg);
        ub.set(LOGIN_TIME, this.getLogin_time(), this.isset_login_time);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(IPADDR, this.getIpaddr(), this.isset_ipaddr);
        ub.set(LOGIN_LOCATION, this.getLogin_location(), this.isset_login_location);
        ub.set(BROWSER, this.getBrowser(), this.isset_browser);
        ub.set(OS, this.getOs(), this.isset_os);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(MSG, this.getMsg(), this.isset_msg);
        ub.set(LOGIN_TIME, this.getLogin_time(), this.isset_login_time);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select info_id, user_name, ipaddr, login_location, browser, os, status, msg, login_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select info_id, user_name, ipaddr, login_location, browser, os, status, msg, login_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_login_info mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_login_info toS_login_info() {
        return super.$clone();
    }
}

/**
 * s_login_info RowMapper
 *
 * @author genrator
 */
class S_login_infoRowMapper implements RowMapper<S_login_info> {

    @Override
    public S_login_info mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_login_info s_login_info = new S_login_info();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.INFO_ID);
        if (columnIndex > 0) {
            s_login_info.setInfo_id(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.USER_NAME);
        if (columnIndex > 0) {
            s_login_info.setUser_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.IPADDR);
        if (columnIndex > 0) {
            s_login_info.setIpaddr(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.LOGIN_LOCATION);
        if (columnIndex > 0) {
            s_login_info.setLogin_location(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.BROWSER);
        if (columnIndex > 0) {
            s_login_info.setBrowser(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.OS);
        if (columnIndex > 0) {
            s_login_info.setOs(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.STATUS);
        if (columnIndex > 0) {
            s_login_info.setStatus(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.MSG);
        if (columnIndex > 0) {
            s_login_info.setMsg(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_login_info_mapper.LOGIN_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_login_info.setLogin_time(null);
            } else {
                s_login_info.setLogin_time(rs.getLong(columnIndex));
            }
        }
        return s_login_info;
    }
}
