package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_MENU *
 * @author genrator
 */
public class S_menu_mapper extends S_menu implements BaseMapper<S_menu> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_menu> ROW_MAPPER = new S_menuRowMapper();

    // 主键
    public static final String MENU_ID = "menu_id";
    // 普通属性
    public static final String MENU_NAME = "menu_name";
    public static final String PARENT_ID = "parent_id";
    public static final String ORDER_NUM = "order_num";
    public static final String PATH = "path";
    public static final String COMPONENT = "component";
    public static final String QUERY = "query";
    public static final String IS_FRAME = "is_frame";
    public static final String IS_CACHE = "is_cache";
    public static final String MENU_TYPE = "menu_type";
    public static final String VISIBLE = "visible";
    public static final String STATUS = "status";
    public static final String PERMS = "perms";
    public static final String ICON = "icon";
    public static final String REMARK = "remark";
    public static final String IS_SHOW = "is_show";
    public static final String TYPE = "type";
    public static final String ICON_INFO = "icon_info";

    /**
     * 默认构造函数
     */
    public S_menu_mapper(S_menu s_menu) {
        if (s_menu == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_menu.isset_menu_id) {
            this.setMenu_id(s_menu.getMenu_id());
        }
        //普通属性
        if (s_menu.isset_menu_name) {
            this.setMenu_name(s_menu.getMenu_name());
        }
        if (s_menu.isset_parent_id) {
            this.setParent_id(s_menu.getParent_id());
        }
        if (s_menu.isset_order_num) {
            this.setOrder_num(s_menu.getOrder_num());
        }
        if (s_menu.isset_path) {
            this.setPath(s_menu.getPath());
        }
        if (s_menu.isset_component) {
            this.setComponent(s_menu.getComponent());
        }
        if (s_menu.isset_query) {
            this.setQuery(s_menu.getQuery());
        }
        if (s_menu.isset_is_frame) {
            this.setIs_frame(s_menu.getIs_frame());
        }
        if (s_menu.isset_is_cache) {
            this.setIs_cache(s_menu.getIs_cache());
        }
        if (s_menu.isset_menu_type) {
            this.setMenu_type(s_menu.getMenu_type());
        }
        if (s_menu.isset_visible) {
            this.setVisible(s_menu.getVisible());
        }
        if (s_menu.isset_status) {
            this.setStatus(s_menu.getStatus());
        }
        if (s_menu.isset_perms) {
            this.setPerms(s_menu.getPerms());
        }
        if (s_menu.isset_icon) {
            this.setIcon(s_menu.getIcon());
        }
        if (s_menu.isset_remark) {
            this.setRemark(s_menu.getRemark());
        }
        if (s_menu.isset_is_show) {
            this.setIs_show(s_menu.getIs_show());
        }
        if (s_menu.isset_type) {
            this.setType(s_menu.getType());
        }
        if (s_menu.isset_icon_info) {
            this.setIcon_info(s_menu.getIcon_info());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_menu.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_menu";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return MENU_ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getMenu_id();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(MENU_ID, this.getMenu_id());
        ib.set(MENU_NAME, this.getMenu_name(), this.isset_menu_name);
        ib.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ib.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ib.set(PATH, this.getPath(), this.isset_path);
        ib.set(COMPONENT, this.getComponent(), this.isset_component);
        ib.set(QUERY, this.getQuery(), this.isset_query);
        ib.set(IS_FRAME, this.getIs_frame(), this.isset_is_frame);
        ib.set(IS_CACHE, this.getIs_cache(), this.isset_is_cache);
        ib.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);
        ib.set(VISIBLE, this.getVisible(), this.isset_visible);
        ib.set(STATUS, this.getStatus(), this.isset_status);
        ib.set(PERMS, this.getPerms(), this.isset_perms);
        ib.set(ICON, this.getIcon(), this.isset_icon);
        ib.set(REMARK, this.getRemark(), this.isset_remark);
        ib.set(IS_SHOW, this.getIs_show(), this.isset_is_show);
        ib.set(TYPE, this.getType(), this.isset_type);
        ib.set(ICON_INFO, this.getIcon_info(), this.isset_icon_info);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MENU_NAME, this.getMenu_name(), this.isset_menu_name);
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ub.set(PATH, this.getPath(), this.isset_path);
        ub.set(COMPONENT, this.getComponent(), this.isset_component);
        ub.set(QUERY, this.getQuery(), this.isset_query);
        ub.set(IS_FRAME, this.getIs_frame(), this.isset_is_frame);
        ub.set(IS_CACHE, this.getIs_cache(), this.isset_is_cache);
        ub.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);
        ub.set(VISIBLE, this.getVisible(), this.isset_visible);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(PERMS, this.getPerms(), this.isset_perms);
        ub.set(ICON, this.getIcon(), this.isset_icon);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(IS_SHOW, this.getIs_show(), this.isset_is_show);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(ICON_INFO, this.getIcon_info(), this.isset_icon_info);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MENU_NAME, this.getMenu_name(), this.isset_menu_name);
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ub.set(PATH, this.getPath(), this.isset_path);
        ub.set(COMPONENT, this.getComponent(), this.isset_component);
        ub.set(QUERY, this.getQuery(), this.isset_query);
        ub.set(IS_FRAME, this.getIs_frame(), this.isset_is_frame);
        ub.set(IS_CACHE, this.getIs_cache(), this.isset_is_cache);
        ub.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);
        ub.set(VISIBLE, this.getVisible(), this.isset_visible);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(PERMS, this.getPerms(), this.isset_perms);
        ub.set(ICON, this.getIcon(), this.isset_icon);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(IS_SHOW, this.getIs_show(), this.isset_is_show);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(ICON_INFO, this.getIcon_info(), this.isset_icon_info);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MENU_NAME, this.getMenu_name(), this.isset_menu_name);
        ub.set(PARENT_ID, this.getParent_id(), this.isset_parent_id);
        ub.set(ORDER_NUM, this.getOrder_num(), this.isset_order_num);
        ub.set(PATH, this.getPath(), this.isset_path);
        ub.set(COMPONENT, this.getComponent(), this.isset_component);
        ub.set(QUERY, this.getQuery(), this.isset_query);
        ub.set(IS_FRAME, this.getIs_frame(), this.isset_is_frame);
        ub.set(IS_CACHE, this.getIs_cache(), this.isset_is_cache);
        ub.set(MENU_TYPE, this.getMenu_type(), this.isset_menu_type);
        ub.set(VISIBLE, this.getVisible(), this.isset_visible);
        ub.set(STATUS, this.getStatus(), this.isset_status);
        ub.set(PERMS, this.getPerms(), this.isset_perms);
        ub.set(ICON, this.getIcon(), this.isset_icon);
        ub.set(REMARK, this.getRemark(), this.isset_remark);
        ub.set(IS_SHOW, this.getIs_show(), this.isset_is_show);
        ub.set(TYPE, this.getType(), this.isset_type);
        ub.set(ICON_INFO, this.getIcon_info(), this.isset_icon_info);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select menu_id, menu_name, parent_id, order_num, path, component, query, is_frame, is_cache, menu_type, visible, status, perms, icon, remark, is_show, type, icon_info from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select menu_id, menu_name, parent_id, order_num, path, component, query, is_frame, is_cache, menu_type, visible, status, perms, icon, remark, is_show, type, icon_info from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_menu mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_menu toS_menu() {
        return super.$clone();
    }
}

/**
 * s_menu RowMapper
 *
 * @author genrator
 */
class S_menuRowMapper implements RowMapper<S_menu> {

    @Override
    public S_menu mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_menu s_menu = new S_menu();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.MENU_ID);
        if (columnIndex > 0) {
            s_menu.setMenu_id(rs.getString(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.MENU_NAME);
        if (columnIndex > 0) {
            s_menu.setMenu_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.PARENT_ID);
        if (columnIndex > 0) {
            s_menu.setParent_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.ORDER_NUM);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_menu.setOrder_num(null);
            } else {
                s_menu.setOrder_num(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.PATH);
        if (columnIndex > 0) {
            s_menu.setPath(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.COMPONENT);
        if (columnIndex > 0) {
            s_menu.setComponent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.QUERY);
        if (columnIndex > 0) {
            s_menu.setQuery(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.IS_FRAME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_menu.setIs_frame(null);
            } else {
                s_menu.setIs_frame(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.IS_CACHE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_menu.setIs_cache(null);
            } else {
                s_menu.setIs_cache(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.MENU_TYPE);
        if (columnIndex > 0) {
            s_menu.setMenu_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.VISIBLE);
        if (columnIndex > 0) {
            s_menu.setVisible(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.STATUS);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_menu.setStatus(null);
            } else {
                s_menu.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.PERMS);
        if (columnIndex > 0) {
            s_menu.setPerms(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.ICON);
        if (columnIndex > 0) {
            s_menu.setIcon(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.REMARK);
        if (columnIndex > 0) {
            s_menu.setRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.IS_SHOW);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_menu.setIs_show(null);
            } else {
                s_menu.setIs_show(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.TYPE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_menu.setType(null);
            } else {
                s_menu.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_menu_mapper.ICON_INFO);
        if (columnIndex > 0) {
            s_menu.setIcon_info(rs.getString(columnIndex));
        }
        return s_menu;
    }
}
