

package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:S_ROLE *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class S_role extends BasePo<S_role> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long role_id = null;
    @JsonIgnore
    protected boolean isset_role_id = false;

    // 属性列表
    private String role_name = null;
    @JsonIgnore
    protected boolean isset_role_name = false;

    private String role_key = null;
    @JsonIgnore
    protected boolean isset_role_key = false;

    private Integer role_sort = null;
    @JsonIgnore
    protected boolean isset_role_sort = false;

    private Integer data_scope = null;
    @JsonIgnore
    protected boolean isset_data_scope = false;

    private Integer menu_check_strictly = null;
    @JsonIgnore
    protected boolean isset_menu_check_strictly = false;

    private Integer dept_check_strictly = null;
    @JsonIgnore
    protected boolean isset_dept_check_strictly = false;

    private Integer status = null;
    @JsonIgnore
    protected boolean isset_status = false;

    private Integer del_flag = null;
    @JsonIgnore
    protected boolean isset_del_flag = false;

    private String remark = null;
    @JsonIgnore
    protected boolean isset_remark = false;

    private Long org_id = null;
    @JsonIgnore
    protected boolean isset_org_id = false;

    private Integer type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    /**
     * 默认构造函数
     */
    public S_role() {
    }

    /**
     * 根据主键构造对象
     */
    public S_role(Long role_id) {
        this.setRole_id(role_id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setRole_id((Long) value);
    }

            public Long getRole_id() {
        return this.role_id;
    }
    public void setRole_id(Long role_id) {
        this.role_id = role_id;
        this.isset_role_id = true;
    }
    @JsonIgnore
    public boolean isEmptyRole_id() {
        return this.role_id == null;
    }


    public String getRole_name() {
        return this.role_name;
    }
    public void setRole_name(String role_name) {
        this.role_name = role_name;
        this.isset_role_name = true;
            }
    @JsonIgnore
    public boolean isEmptyRole_name() {
        return this.role_name == null || this.role_name.length() == 0;
    }


    public String getRole_key() {
        return this.role_key;
    }
    public void setRole_key(String role_key) {
        this.role_key = role_key;
        this.isset_role_key = true;
            }
    @JsonIgnore
    public boolean isEmptyRole_key() {
        return this.role_key == null || this.role_key.length() == 0;
    }


    public Integer getRole_sort() {
        return this.role_sort;
    }
    public void setRole_sort(Integer role_sort) {
        this.role_sort = role_sort;
        this.isset_role_sort = true;
            }
    @JsonIgnore
    public boolean isEmptyRole_sort() {
        return this.role_sort == null;
    }


    public Integer getData_scope() {
        return this.data_scope;
    }
    public void setData_scope(Integer data_scope) {
        this.data_scope = data_scope;
        this.isset_data_scope = true;
            }
    @JsonIgnore
    public boolean isEmptyData_scope() {
        return this.data_scope == null;
    }


    public Integer getMenu_check_strictly() {
        return this.menu_check_strictly;
    }
    public void setMenu_check_strictly(Integer menu_check_strictly) {
        this.menu_check_strictly = menu_check_strictly;
        this.isset_menu_check_strictly = true;
            }
    @JsonIgnore
    public boolean isEmptyMenu_check_strictly() {
        return this.menu_check_strictly == null;
    }


    public Integer getDept_check_strictly() {
        return this.dept_check_strictly;
    }
    public void setDept_check_strictly(Integer dept_check_strictly) {
        this.dept_check_strictly = dept_check_strictly;
        this.isset_dept_check_strictly = true;
            }
    @JsonIgnore
    public boolean isEmptyDept_check_strictly() {
        return this.dept_check_strictly == null;
    }


    public Integer getStatus() {
        return this.status;
    }
    public void setStatus(Integer status) {
        this.status = status;
        this.isset_status = true;
            }
    @JsonIgnore
    public boolean isEmptyStatus() {
        return this.status == null;
    }


    public Integer getDel_flag() {
        return this.del_flag;
    }
    public void setDel_flag(Integer del_flag) {
        this.del_flag = del_flag;
        this.isset_del_flag = true;
            }
    @JsonIgnore
    public boolean isEmptyDel_flag() {
        return this.del_flag == null;
    }


    public String getRemark() {
        return this.remark;
    }
    public void setRemark(String remark) {
        this.remark = remark;
        this.isset_remark = true;
            }
    @JsonIgnore
    public boolean isEmptyRemark() {
        return this.remark == null || this.remark.length() == 0;
    }


    public Long getOrg_id() {
        return this.org_id;
    }
    public void setOrg_id(Long org_id) {
        this.org_id = org_id;
        this.isset_org_id = true;
            }
    @JsonIgnore
    public boolean isEmptyOrg_id() {
        return this.org_id == null;
    }


    public Integer getType() {
        return this.type;
    }
    public void setType(Integer type) {
        this.type = type;
        this.isset_type = true;
            }
    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null;
    }


    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("role_id=").append(this.role_id)
                .append("role_name=").append(this.role_name)
                .append("role_key=").append(this.role_key)
                .append("role_sort=").append(this.role_sort)
                .append("data_scope=").append(this.data_scope)
                .append("menu_check_strictly=").append(this.menu_check_strictly)
                .append("dept_check_strictly=").append(this.dept_check_strictly)
                .append("status=").append(this.status)
                .append("del_flag=").append(this.del_flag)
                .append("remark=").append(this.remark)
                .append("org_id=").append(this.org_id)
                .append("type=").append(this.type)
                .toString();
    }

    /**
     * 克隆
     */
    public S_role $clone() {
        S_role s_role = new S_role();

        // 数据库名称
        //s_role.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_role_id) {
            s_role.setRole_id(this.getRole_id());
        }
        // 普通属性
        if (this.isset_role_name) {
            s_role.setRole_name(this.getRole_name());
        }
        if (this.isset_role_key) {
            s_role.setRole_key(this.getRole_key());
        }
        if (this.isset_role_sort) {
            s_role.setRole_sort(this.getRole_sort());
        }
        if (this.isset_data_scope) {
            s_role.setData_scope(this.getData_scope());
        }
        if (this.isset_menu_check_strictly) {
            s_role.setMenu_check_strictly(this.getMenu_check_strictly());
        }
        if (this.isset_dept_check_strictly) {
            s_role.setDept_check_strictly(this.getDept_check_strictly());
        }
        if (this.isset_status) {
            s_role.setStatus(this.getStatus());
        }
        if (this.isset_del_flag) {
            s_role.setDel_flag(this.getDel_flag());
        }
        if (this.isset_remark) {
            s_role.setRemark(this.getRemark());
        }
        if (this.isset_org_id) {
            s_role.setOrg_id(this.getOrg_id());
        }
        if (this.isset_type) {
            s_role.setType(this.getType());
        }
        return s_role;
    }
}
