package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_USER_PROFILE *
 * @author genrator
 */
public class S_user_profile_mapper extends S_user_profile implements BaseMapper<S_user_profile> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_user_profile> ROW_MAPPER = new S_user_profileRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String CREATE_TIME = "create_time";
    public static final String MOBILE = "mobile";
    public static final String MOBILE_HISTORY = "mobile_history";
    public static final String CARD_NO = "card_no";
    public static final String MAIL = "mail";
    public static final String BIRTHDAY = "birthday";
    public static final String SEX = "sex";
    public static final String CARD_FRONT_IMG = "card_front_img";
    public static final String CARD_BACK_IMG = "card_back_img";
    public static final String FACE_IMG = "face_img";
    public static final String NAME = "name";
    public static final String THIRD_ACCT = "third_acct";
    public static final String SUMMARY = "summary";
    public static final String ORG_ID = "org_id";
    public static final String DEPT_ID = "dept_id";
    public static final String ORG_NAME = "org_name";
    public static final String DEPT_NAME = "dept_name";

    /**
     * 默认构造函数
     */
    public S_user_profile_mapper(S_user_profile s_user_profile) {
        if (s_user_profile == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_user_profile.isset_id) {
            this.setId(s_user_profile.getId());
        }
        //普通属性
        if (s_user_profile.isset_create_time) {
            this.setCreate_time(s_user_profile.getCreate_time());
        }
        if (s_user_profile.isset_mobile) {
            this.setMobile(s_user_profile.getMobile());
        }
        if (s_user_profile.isset_mobile_history) {
            this.setMobile_history(s_user_profile.getMobile_history());
        }
        if (s_user_profile.isset_card_no) {
            this.setCard_no(s_user_profile.getCard_no());
        }
        if (s_user_profile.isset_mail) {
            this.setMail(s_user_profile.getMail());
        }
        if (s_user_profile.isset_birthday) {
            this.setBirthday(s_user_profile.getBirthday());
        }
        if (s_user_profile.isset_sex) {
            this.setSex(s_user_profile.getSex());
        }
        if (s_user_profile.isset_card_front_img) {
            this.setCard_front_img(s_user_profile.getCard_front_img());
        }
        if (s_user_profile.isset_card_back_img) {
            this.setCard_back_img(s_user_profile.getCard_back_img());
        }
        if (s_user_profile.isset_face_img) {
            this.setFace_img(s_user_profile.getFace_img());
        }
        if (s_user_profile.isset_name) {
            this.setName(s_user_profile.getName());
        }
        if (s_user_profile.isset_third_acct) {
            this.setThird_acct(s_user_profile.getThird_acct());
        }
        if (s_user_profile.isset_summary) {
            this.setSummary(s_user_profile.getSummary());
        }
        if (s_user_profile.isset_org_id) {
            this.setOrg_id(s_user_profile.getOrg_id());
        }
        if (s_user_profile.isset_dept_id) {
            this.setDept_id(s_user_profile.getDept_id());
        }
        if (s_user_profile.isset_org_name) {
            this.setOrg_name(s_user_profile.getOrg_name());
        }
        if (s_user_profile.isset_dept_name) {
            this.setDept_name(s_user_profile.getDept_name());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_user_profile.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_user_profile";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(MOBILE, this.getMobile(), this.isset_mobile);
        ib.set(MOBILE_HISTORY, this.getMobile_history(), this.isset_mobile_history);
        ib.set(CARD_NO, this.getCard_no(), this.isset_card_no);
        ib.set(MAIL, this.getMail(), this.isset_mail);
        ib.set(BIRTHDAY, this.getBirthday(), this.isset_birthday);
        ib.set(SEX, this.getSex(), this.isset_sex);
        ib.set(CARD_FRONT_IMG, this.getCard_front_img(), this.isset_card_front_img);
        ib.set(CARD_BACK_IMG, this.getCard_back_img(), this.isset_card_back_img);
        ib.set(FACE_IMG, this.getFace_img(), this.isset_face_img);
        ib.set(NAME, this.getName(), this.isset_name);
        ib.set(THIRD_ACCT, this.getThird_acct(), this.isset_third_acct);
        ib.set(SUMMARY, this.getSummary(), this.isset_summary);
        ib.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ib.set(DEPT_ID, this.getDept_id(), this.isset_dept_id);
        ib.set(ORG_NAME, this.getOrg_name(), this.isset_org_name);
        ib.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(MOBILE, this.getMobile(), this.isset_mobile);
        ub.set(MOBILE_HISTORY, this.getMobile_history(), this.isset_mobile_history);
        ub.set(CARD_NO, this.getCard_no(), this.isset_card_no);
        ub.set(MAIL, this.getMail(), this.isset_mail);
        ub.set(BIRTHDAY, this.getBirthday(), this.isset_birthday);
        ub.set(SEX, this.getSex(), this.isset_sex);
        ub.set(CARD_FRONT_IMG, this.getCard_front_img(), this.isset_card_front_img);
        ub.set(CARD_BACK_IMG, this.getCard_back_img(), this.isset_card_back_img);
        ub.set(FACE_IMG, this.getFace_img(), this.isset_face_img);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(THIRD_ACCT, this.getThird_acct(), this.isset_third_acct);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(DEPT_ID, this.getDept_id(), this.isset_dept_id);
        ub.set(ORG_NAME, this.getOrg_name(), this.isset_org_name);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(MOBILE, this.getMobile(), this.isset_mobile);
        ub.set(MOBILE_HISTORY, this.getMobile_history(), this.isset_mobile_history);
        ub.set(CARD_NO, this.getCard_no(), this.isset_card_no);
        ub.set(MAIL, this.getMail(), this.isset_mail);
        ub.set(BIRTHDAY, this.getBirthday(), this.isset_birthday);
        ub.set(SEX, this.getSex(), this.isset_sex);
        ub.set(CARD_FRONT_IMG, this.getCard_front_img(), this.isset_card_front_img);
        ub.set(CARD_BACK_IMG, this.getCard_back_img(), this.isset_card_back_img);
        ub.set(FACE_IMG, this.getFace_img(), this.isset_face_img);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(THIRD_ACCT, this.getThird_acct(), this.isset_third_acct);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(DEPT_ID, this.getDept_id(), this.isset_dept_id);
        ub.set(ORG_NAME, this.getOrg_name(), this.isset_org_name);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(MOBILE, this.getMobile(), this.isset_mobile);
        ub.set(MOBILE_HISTORY, this.getMobile_history(), this.isset_mobile_history);
        ub.set(CARD_NO, this.getCard_no(), this.isset_card_no);
        ub.set(MAIL, this.getMail(), this.isset_mail);
        ub.set(BIRTHDAY, this.getBirthday(), this.isset_birthday);
        ub.set(SEX, this.getSex(), this.isset_sex);
        ub.set(CARD_FRONT_IMG, this.getCard_front_img(), this.isset_card_front_img);
        ub.set(CARD_BACK_IMG, this.getCard_back_img(), this.isset_card_back_img);
        ub.set(FACE_IMG, this.getFace_img(), this.isset_face_img);
        ub.set(NAME, this.getName(), this.isset_name);
        ub.set(THIRD_ACCT, this.getThird_acct(), this.isset_third_acct);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);
        ub.set(ORG_ID, this.getOrg_id(), this.isset_org_id);
        ub.set(DEPT_ID, this.getDept_id(), this.isset_dept_id);
        ub.set(ORG_NAME, this.getOrg_name(), this.isset_org_name);
        ub.set(DEPT_NAME, this.getDept_name(), this.isset_dept_name);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, mobile, mobile_history, card_no, mail, birthday, sex, card_front_img, card_back_img, face_img, name, third_acct, summary, org_id, dept_id, org_name, dept_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, mobile, mobile_history, card_no, mail, birthday, sex, card_front_img, card_back_img, face_img, name, third_acct, summary, org_id, dept_id, org_name, dept_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_user_profile mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_user_profile toS_user_profile() {
        return super.$clone();
    }
}

/**
 * s_user_profile RowMapper
 *
 * @author genrator
 */
class S_user_profileRowMapper implements RowMapper<S_user_profile> {

    @Override
    public S_user_profile mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_user_profile s_user_profile = new S_user_profile();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.ID);
        if (columnIndex > 0) {
            s_user_profile.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_profile.setCreate_time(null);
            } else {
                s_user_profile.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.MOBILE);
        if (columnIndex > 0) {
            s_user_profile.setMobile(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.MOBILE_HISTORY);
        if (columnIndex > 0) {
            s_user_profile.setMobile_history(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.CARD_NO);
        if (columnIndex > 0) {
            s_user_profile.setCard_no(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.MAIL);
        if (columnIndex > 0) {
            s_user_profile.setMail(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.BIRTHDAY);
        if (columnIndex > 0) {
            s_user_profile.setBirthday(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.SEX);
        if (columnIndex > 0) {
            s_user_profile.setSex(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.CARD_FRONT_IMG);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_profile.setCard_front_img(null);
            } else {
                s_user_profile.setCard_front_img(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.CARD_BACK_IMG);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_profile.setCard_back_img(null);
            } else {
                s_user_profile.setCard_back_img(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.FACE_IMG);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_profile.setFace_img(null);
            } else {
                s_user_profile.setFace_img(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.NAME);
        if (columnIndex > 0) {
            s_user_profile.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.THIRD_ACCT);
        if (columnIndex > 0) {
            s_user_profile.setThird_acct(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.SUMMARY);
        if (columnIndex > 0) {
            s_user_profile.setSummary(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.ORG_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_profile.setOrg_id(null);
            } else {
                s_user_profile.setOrg_id(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.DEPT_ID);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_user_profile.setDept_id(null);
            } else {
                s_user_profile.setDept_id(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.ORG_NAME);
        if (columnIndex > 0) {
            s_user_profile.setOrg_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_user_profile_mapper.DEPT_NAME);
        if (columnIndex > 0) {
            s_user_profile.setDept_name(rs.getString(columnIndex));
        }
        return s_user_profile;
    }
}
